"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
// tslint:disable-next-line:max-line-length
function renderAmazonLinuxUserData(clusterName, autoScalingGroup, options = {}) {
    const stack = core_1.Stack.of(autoScalingGroup);
    // determine logical id of ASG so we can signal cloudformation
    const cfn = autoScalingGroup.node.defaultChild;
    const asgLogicalId = cfn.logicalId;
    const extraArgs = new Array();
    extraArgs.push(`--use-max-pods ${options.useMaxPods === undefined ? true : options.useMaxPods}`);
    if (options.awsApiRetryAttempts) {
        extraArgs.push(`--aws-api-retry-attempts ${options.awsApiRetryAttempts}`);
    }
    if (options.enableDockerBridge) {
        extraArgs.push('--enable-docker-bridge');
    }
    if (options.dockerConfigJson) {
        extraArgs.push(`--docker-config-json '${options.dockerConfigJson}'`);
    }
    if (options.additionalArgs) {
        extraArgs.push(options.additionalArgs);
    }
    const commandLineSuffix = extraArgs.join(' ');
    const kubeletExtraArgsSuffix = options.kubeletExtraArgs || '';
    // determine lifecycle label based on whether the ASG has a spot price.
    const lifecycleLabel = autoScalingGroup.spotPrice ? LifecycleLabel.SPOT : LifecycleLabel.ON_DEMAND;
    const withTaints = autoScalingGroup.spotPrice ? '--register-with-taints=spotInstance=true:PreferNoSchedule' : '';
    const kubeletExtraArgs = `--node-labels lifecycle=${lifecycleLabel} ${withTaints} ${kubeletExtraArgsSuffix}`.trim();
    return [
        'set -o xtrace',
        `/etc/eks/bootstrap.sh ${clusterName} --kubelet-extra-args "${kubeletExtraArgs}" ${commandLineSuffix}`.trim(),
        `/opt/aws/bin/cfn-signal --exit-code $? --stack ${stack.stackName} --resource ${asgLogicalId} --region ${stack.region}`,
    ];
}
exports.renderAmazonLinuxUserData = renderAmazonLinuxUserData;
function renderBottlerocketUserData(cluster) {
    return [
        '[settings.kubernetes]',
        `api-server="${cluster.clusterEndpoint}"`,
        `cluster-certificate="${cluster.clusterCertificateAuthorityData}"`,
        `cluster-name="${cluster.clusterName}"`,
    ];
}
exports.renderBottlerocketUserData = renderBottlerocketUserData;
/**
 * The lifecycle label for node selector
 */
var LifecycleLabel;
(function (LifecycleLabel) {
    /**
     * on-demand instances
     */
    LifecycleLabel["ON_DEMAND"] = "OnDemand";
    /**
     * spot instances
     */
    LifecycleLabel["SPOT"] = "Ec2Spot";
})(LifecycleLabel = exports.LifecycleLabel || (exports.LifecycleLabel = {}));
//# sourceMappingURL=data:application/json;base64,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