"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cluster_1 = require("./cluster");
/**
 * Defines an EKS cluster that runs entirely on AWS Fargate.
 *
 * The cluster is created with a default Fargate Profile that matches the
 * "default" and "kube-system" namespaces. You can add additional profiles using
 * `addFargateProfile`.
 */
class FargateCluster extends cluster_1.Cluster {
    constructor(scope, id, props = {}) {
        var _a, _b, _c, _d;
        super(scope, id, {
            ...props,
            defaultCapacity: 0,
            kubectlEnabled: true,
            coreDnsComputeType: (_a = props.coreDnsComputeType) !== null && _a !== void 0 ? _a : cluster_1.CoreDnsComputeType.FARGATE,
        });
        this.addFargateProfile((_c = (_b = props.defaultProfile) === null || _b === void 0 ? void 0 : _b.fargateProfileName) !== null && _c !== void 0 ? _c : (props.defaultProfile ? 'custom' : 'default'), (_d = props.defaultProfile) !== null && _d !== void 0 ? _d : {
            selectors: [
                { namespace: 'default' },
                { namespace: 'kube-system' },
            ],
        });
    }
}
exports.FargateCluster = FargateCluster;
//# sourceMappingURL=data:application/json;base64,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