"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// eslint-disable-next-line import/no-extraneous-dependencies
const aws = require("aws-sdk");
const cluster_1 = require("./cluster");
const consts = require("./consts");
const fargate_1 = require("./fargate");
aws.config.logger = console;
let eks;
const defaultEksClient = {
    createCluster: req => getEksClient().createCluster(req).promise(),
    deleteCluster: req => getEksClient().deleteCluster(req).promise(),
    describeCluster: req => getEksClient().describeCluster(req).promise(),
    describeUpdate: req => getEksClient().describeUpdate(req).promise(),
    updateClusterConfig: req => getEksClient().updateClusterConfig(req).promise(),
    updateClusterVersion: req => getEksClient().updateClusterVersion(req).promise(),
    createFargateProfile: req => getEksClient().createFargateProfile(req).promise(),
    deleteFargateProfile: req => getEksClient().deleteFargateProfile(req).promise(),
    describeFargateProfile: req => getEksClient().describeFargateProfile(req).promise(),
    configureAssumeRole: req => {
        console.log(JSON.stringify({ assumeRole: req }, undefined, 2));
        const creds = new aws.ChainableTemporaryCredentials({
            params: req,
        });
        eks = new aws.EKS({ credentials: creds });
    },
};
function getEksClient() {
    if (!eks) {
        throw new Error('EKS client not initialized (call "configureAssumeRole")');
    }
    return eks;
}
async function onEvent(event) {
    const provider = createResourceHandler(event);
    return provider.onEvent();
}
exports.onEvent = onEvent;
async function isComplete(event) {
    const provider = createResourceHandler(event);
    return provider.isComplete();
}
exports.isComplete = isComplete;
function createResourceHandler(event) {
    switch (event.ResourceType) {
        case consts.CLUSTER_RESOURCE_TYPE: return new cluster_1.ClusterResourceHandler(defaultEksClient, event);
        case consts.FARGATE_PROFILE_RESOURCE_TYPE: return new fargate_1.FargateProfileResourceHandler(defaultEksClient, event);
        default:
            throw new Error(`Unsupported resource type "${event.ResourceType}`);
    }
}
//# sourceMappingURL=data:application/json;base64,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