"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class ResourceHandler {
    constructor(eks, event) {
        this.eks = eks;
        this.requestType = event.RequestType;
        this.requestId = event.RequestId;
        this.logicalResourceId = event.LogicalResourceId;
        this.physicalResourceId = event.PhysicalResourceId;
        this.event = event;
        const roleToAssume = event.ResourceProperties.AssumeRoleArn;
        if (!roleToAssume) {
            throw new Error('AssumeRoleArn must be provided');
        }
        eks.configureAssumeRole({
            RoleArn: roleToAssume,
            RoleSessionName: `AWSCDK.EKSCluster.${this.requestType}.${this.requestId}`,
        });
    }
    onEvent() {
        switch (this.requestType) {
            case 'Create': return this.onCreate();
            case 'Update': return this.onUpdate();
            case 'Delete': return this.onDelete();
        }
        throw new Error(`Invalid request type ${this.requestType}`);
    }
    isComplete() {
        switch (this.requestType) {
            case 'Create': return this.isCreateComplete();
            case 'Update': return this.isUpdateComplete();
            case 'Delete': return this.isDeleteComplete();
        }
        throw new Error(`Invalid request type ${this.requestType}`);
    }
    log(x) {
        // tslint:disable-next-line: no-console
        console.log(JSON.stringify(x, undefined, 2));
    }
}
exports.ResourceHandler = ResourceHandler;
//# sourceMappingURL=data:application/json;base64,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