"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_log_driver_1 = require("./aws-log-driver");
const firelens_log_driver_1 = require("./firelens-log-driver");
const fluentd_log_driver_1 = require("./fluentd-log-driver");
const gelf_log_driver_1 = require("./gelf-log-driver");
const journald_log_driver_1 = require("./journald-log-driver");
const json_file_log_driver_1 = require("./json-file-log-driver");
const splunk_log_driver_1 = require("./splunk-log-driver");
const syslog_log_driver_1 = require("./syslog-log-driver");
/**
 * The base class for log drivers.
 */
class LogDrivers {
    /**
     * Creates a log driver configuration that sends log information to CloudWatch Logs.
     */
    static awsLogs(props) {
        return new aws_log_driver_1.AwsLogDriver(props);
    }
    /**
     * Creates a log driver configuration that sends log information to fluentd Logs.
     */
    static fluentd(props) {
        return new fluentd_log_driver_1.FluentdLogDriver(props);
    }
    /**
     * Creates a log driver configuration that sends log information to gelf Logs.
     */
    static gelf(props) {
        return new gelf_log_driver_1.GelfLogDriver(props);
    }
    /**
     * Creates a log driver configuration that sends log information to journald Logs.
     */
    static journald(props) {
        return new journald_log_driver_1.JournaldLogDriver(props);
    }
    /**
     * Creates a log driver configuration that sends log information to json-file Logs.
     */
    static jsonFile(props) {
        return new json_file_log_driver_1.JsonFileLogDriver(props);
    }
    /**
     * Creates a log driver configuration that sends log information to splunk Logs.
     */
    static splunk(props) {
        return new splunk_log_driver_1.SplunkLogDriver(props);
    }
    /**
     * Creates a log driver configuration that sends log information to syslog Logs.
     */
    static syslog(props) {
        return new syslog_log_driver_1.SyslogLogDriver(props);
    }
    /**
     * Creates a log driver configuration that sends log information to firelens log router.
     * For detail configurations, please refer to Amazon ECS FireLens Examples:
     * https://github.com/aws-samples/amazon-ecs-firelens-examples
     */
    static firelens(props) {
        return new firelens_log_driver_1.FireLensLogDriver(props);
    }
}
exports.LogDrivers = LogDrivers;
//# sourceMappingURL=data:application/json;base64,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