"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const task_definition_1 = require("../base/task-definition");
/**
 * The details of a task definition run on an EC2 cluster.
 *
 * @resource AWS::ECS::TaskDefinition
 */
class Ec2TaskDefinition extends task_definition_1.TaskDefinition {
    /**
     * Imports a task definition from the specified task definition ARN.
     */
    static fromEc2TaskDefinitionArn(scope, id, ec2TaskDefinitionArn) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.taskDefinitionArn = ec2TaskDefinitionArn;
                this.compatibility = task_definition_1.Compatibility.EC2;
                this.isEc2Compatible = true;
                this.isFargateCompatible = false;
            }
        }
        return new Import(scope, id);
    }
    /**
     * Constructs a new instance of the Ec2TaskDefinition class.
     */
    constructor(scope, id, props = {}) {
        super(scope, id, {
            ...props,
            compatibility: task_definition_1.Compatibility.EC2,
            placementConstraints: props.placementConstraints,
            ipcMode: props.ipcMode,
            pidMode: props.pidMode,
        });
    }
}
exports.Ec2TaskDefinition = Ec2TaskDefinition;
//# sourceMappingURL=data:application/json;base64,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