"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
function fromServiceAtrributes(scope, id, attrs) {
    if ((attrs.serviceArn && attrs.serviceName) || (!attrs.serviceArn && !attrs.serviceName)) {
        throw new Error('You can only specify either serviceArn or serviceName.');
    }
    const stack = core_1.Stack.of(scope);
    let name;
    let arn;
    if (attrs.serviceName) {
        name = attrs.serviceName;
        arn = stack.formatArn({
            partition: stack.partition,
            service: 'ecs',
            region: stack.region,
            account: stack.account,
            resource: 'service',
            resourceName: name,
        });
    }
    else {
        arn = attrs.serviceArn;
        name = stack.parseArn(arn).resourceName;
    }
    class Import extends core_1.Resource {
        constructor() {
            super(...arguments);
            this.serviceArn = arn;
            this.serviceName = name;
            this.cluster = attrs.cluster;
        }
    }
    return new Import(scope, id);
}
exports.fromServiceAtrributes = fromServiceAtrributes;
//# sourceMappingURL=data:application/json;base64,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