"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_ecs_1 = require("../../../aws-ecs"); // Automatically re-written from '@aws-cdk/aws-ecs'
const scheduled_task_base_1 = require("../base/scheduled-task-base");
/**
 * A scheduled EC2 task that will be initiated off of CloudWatch Events.
 */
class ScheduledEc2Task extends scheduled_task_base_1.ScheduledTaskBase {
    /**
     * Constructs a new instance of the ScheduledEc2Task class.
     */
    constructor(scope, id, props) {
        super(scope, id, props);
        if (props.scheduledEc2TaskDefinitionOptions && props.scheduledEc2TaskImageOptions) {
            throw new Error('You must specify either a scheduledEc2TaskDefinitionOptions or scheduledEc2TaskOptions, not both.');
        }
        else if (props.scheduledEc2TaskDefinitionOptions) {
            this.taskDefinition = props.scheduledEc2TaskDefinitionOptions.taskDefinition;
        }
        else if (props.scheduledEc2TaskImageOptions) {
            const taskImageOptions = props.scheduledEc2TaskImageOptions;
            // Create a Task Definition for the container to start, also creates a log driver
            this.taskDefinition = new aws_ecs_1.Ec2TaskDefinition(this, 'ScheduledTaskDef');
            this.taskDefinition.addContainer('ScheduledContainer', {
                image: taskImageOptions.image,
                memoryLimitMiB: taskImageOptions.memoryLimitMiB,
                memoryReservationMiB: taskImageOptions.memoryReservationMiB,
                cpu: taskImageOptions.cpu,
                command: taskImageOptions.command,
                environment: taskImageOptions.environment,
                secrets: taskImageOptions.secrets,
                logging: taskImageOptions.logDriver !== undefined ? taskImageOptions.logDriver : this.createAWSLogDriver(this.node.id),
            });
        }
        else {
            throw new Error('You must specify a taskDefinition or image');
        }
        this.addTaskDefinitionToEventTarget(this.taskDefinition);
    }
}
exports.ScheduledEc2Task = ScheduledEc2Task;
//# sourceMappingURL=data:application/json;base64,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