"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_ecs_1 = require("../../../aws-ecs"); // Automatically re-written from '@aws-cdk/aws-ecs'
const queue_processing_service_base_1 = require("../base/queue-processing-service-base");
/**
 * Class to create a queue processing EC2 service.
 */
class QueueProcessingEc2Service extends queue_processing_service_base_1.QueueProcessingServiceBase {
    /**
     * Constructs a new instance of the QueueProcessingEc2Service class.
     */
    constructor(scope, id, props) {
        super(scope, id, props);
        // Create a Task Definition for the container to start
        this.taskDefinition = new aws_ecs_1.Ec2TaskDefinition(this, 'QueueProcessingTaskDef', {
            family: props.family,
        });
        this.taskDefinition.addContainer('QueueProcessingContainer', {
            image: props.image,
            memoryLimitMiB: props.memoryLimitMiB,
            memoryReservationMiB: props.memoryReservationMiB,
            cpu: props.cpu,
            command: props.command,
            environment: this.environment,
            secrets: this.secrets,
            logging: this.logDriver,
        });
        // Create an ECS service with the previously defined Task Definition and configure
        // autoscaling based on cpu utilization and number of messages visible in the SQS queue.
        this.service = new aws_ecs_1.Ec2Service(this, 'QueueProcessingService', {
            cluster: this.cluster,
            desiredCount: this.desiredCount,
            taskDefinition: this.taskDefinition,
            serviceName: props.serviceName,
            propagateTags: props.propagateTags,
            enableECSManagedTags: props.enableECSManagedTags,
        });
        this.configureAutoscalingForService(this.service);
        this.grantPermissionsToService(this.service);
    }
}
exports.QueueProcessingEc2Service = QueueProcessingEc2Service;
//# sourceMappingURL=data:application/json;base64,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