"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * What class and generation of instance to use
 *
 * We have both symbolic and concrete enums for every type.
 *
 * The first are for people that want to specify by purpose,
 * the second one are for people who already know exactly what
 * 'R4' means.
 */
var InstanceClass;
(function (InstanceClass) {
    /**
     * Standard instances, 3rd generation
     */
    InstanceClass["STANDARD3"] = "m3";
    /**
     * Standard instances, 3rd generation
     */
    InstanceClass["M3"] = "m3";
    /**
     * Standard instances, 4th generation
     */
    InstanceClass["STANDARD4"] = "m4";
    /**
     * Standard instances, 4th generation
     */
    InstanceClass["M4"] = "m4";
    /**
     * Standard instances, 5th generation
     */
    InstanceClass["STANDARD5"] = "m5";
    /**
     * Standard instances, 5th generation
     */
    InstanceClass["M5"] = "m5";
    /**
     * Standard instances with local NVME drive, 5th generation
     */
    InstanceClass["STANDARD5_NVME_DRIVE"] = "m5d";
    /**
     * Standard instances with local NVME drive, 5th generation
     */
    InstanceClass["M5D"] = "m5d";
    /**
     * Standard instances based on AMD EPYC, 5th generation
     */
    InstanceClass["STANDARD5_AMD"] = "m5a";
    /**
     * Standard instances based on AMD EPYC, 5th generation
     */
    InstanceClass["M5A"] = "m5a";
    /**
     * Standard instances based on AMD EPYC with local NVME drive, 5th generation
     */
    InstanceClass["STANDARD5_AMD_NVME_DRIVE"] = "m5ad";
    /**
     * Standard instances based on AMD EPYC with local NVME drive, 5th generation
     */
    InstanceClass["M5AD"] = "m5ad";
    /**
     * Memory optimized instances, 3rd generation
     */
    InstanceClass["MEMORY3"] = "r3";
    /**
     * Memory optimized instances, 3rd generation
     */
    InstanceClass["R3"] = "r3";
    /**
     * Memory optimized instances, 4th generation
     */
    InstanceClass["MEMORY4"] = "r4";
    /**
     * Memory optimized instances, 4th generation
     */
    InstanceClass["R4"] = "r4";
    /**
     * Memory optimized instances, 5th generation
     */
    InstanceClass["MEMORY5"] = "r5";
    /**
     * Memory optimized instances, 5th generation
     */
    InstanceClass["R5"] = "r5";
    /**
     * Memory optimized instances for high performance computing, 5th generation
     */
    InstanceClass["MEMORY5_HIGH_PERFORMANCE"] = "r5n";
    /**
     * Memory optimized instances for high performance computing, 5th generation
     */
    InstanceClass["R5N"] = "r5n";
    /**
     * Memory optimized instances with local NVME drive, 5th generation
     */
    InstanceClass["MEMORY5_NVME_DRIVE"] = "r5d";
    /**
     * Memory optimized instances with local NVME drive, 5th generation
     */
    InstanceClass["R5D"] = "r5d";
    /**
     * Memory optimized instances with local NVME drive for high performance computing, 5th generation
     */
    InstanceClass["MEMORY5_NVME_DRIVE_HIGH_PERFORMANCE"] = "r5dn";
    /**
     * Memory optimized instances with local NVME drive for high performance computing, 5th generation
     */
    InstanceClass["R5DN"] = "r5dn";
    /**
     * Memory optimized instances based on AMD EPYC, 5th generation
     */
    InstanceClass["MEMORY5_AMD"] = "r5a";
    /**
     * Memory optimized instances based on AMD EPYC, 5th generation
     */
    InstanceClass["R5A"] = "r5a";
    /**
     * Memory optimized instances based on AMD EPYC with local NVME drive, 5th generation
     */
    InstanceClass["MEMORY5_AMD_NVME_DRIVE"] = "r5a";
    /**
     * Memory optimized instances based on AMD EPYC with local NVME drive, 5th generation
     */
    InstanceClass["R5AD"] = "r5a";
    /**
     * Compute optimized instances, 3rd generation
     */
    InstanceClass["COMPUTE3"] = "c3";
    /**
     * Compute optimized instances, 3rd generation
     */
    InstanceClass["C3"] = "c3";
    /**
     * Compute optimized instances, 4th generation
     */
    InstanceClass["COMPUTE4"] = "c4";
    /**
     * Compute optimized instances, 4th generation
     */
    InstanceClass["C4"] = "c4";
    /**
     * Compute optimized instances, 5th generation
     */
    InstanceClass["COMPUTE5"] = "c5";
    /**
     * Compute optimized instances, 5th generation
     */
    InstanceClass["C5"] = "c5";
    /**
     * Compute optimized instances with local NVME drive, 5th generation
     */
    InstanceClass["COMPUTE5_NVME_DRIVE"] = "c5d";
    /**
     * Compute optimized instances with local NVME drive, 5th generation
     */
    InstanceClass["C5D"] = "c5d";
    /**
     * Compute optimized instances for high performance computing, 5th generation
     */
    InstanceClass["COMPUTE5_HIGH_PERFORMANCE"] = "c5n";
    /**
     * Compute optimized instances for high performance computing, 5th generation
     */
    InstanceClass["C5N"] = "c5n";
    /**
     * Storage-optimized instances, 2nd generation
     */
    InstanceClass["STORAGE2"] = "d2";
    /**
     * Storage-optimized instances, 2nd generation
     */
    InstanceClass["D2"] = "d2";
    /**
     * Storage/compute balanced instances, 1st generation
     */
    InstanceClass["STORAGE_COMPUTE_1"] = "h1";
    /**
     * Storage/compute balanced instances, 1st generation
     */
    InstanceClass["H1"] = "h1";
    /**
     * I/O-optimized instances, 3rd generation
     */
    InstanceClass["IO3"] = "i3";
    /**
     * I/O-optimized instances, 3rd generation
     */
    InstanceClass["I3"] = "i3";
    /**
     * I/O-optimized instances with local NVME drive, 3rd generation
     */
    InstanceClass["IO3_DENSE_NVME_DRIVE"] = "i3en";
    /**
     * I/O-optimized instances with local NVME drive, 3rd generation
     */
    InstanceClass["I3EN"] = "i3en";
    /**
     * Burstable instances, 2nd generation
     */
    InstanceClass["BURSTABLE2"] = "t2";
    /**
     * Burstable instances, 2nd generation
     */
    InstanceClass["T2"] = "t2";
    /**
     * Burstable instances, 3rd generation
     */
    InstanceClass["BURSTABLE3"] = "t3";
    /**
     * Burstable instances, 3rd generation
     */
    InstanceClass["T3"] = "t3";
    /**
     * Burstable instances based on AMD EPYC, 3rd generation
     */
    InstanceClass["BURSTABLE3_AMD"] = "t3a";
    /**
     * Burstable instances based on AMD EPYC, 3rd generation
     */
    InstanceClass["T3A"] = "t3a";
    /**
     * Memory-intensive instances, 1st generation
     */
    InstanceClass["MEMORY_INTENSIVE_1"] = "x1";
    /**
     * Memory-intensive instances, 1st generation
     */
    InstanceClass["X1"] = "x1";
    /**
     * Memory-intensive instances, extended, 1st generation
     */
    InstanceClass["MEMORY_INTENSIVE_1_EXTENDED"] = "x1e";
    /**
     * Memory-intensive instances, 1st generation
     */
    InstanceClass["X1E"] = "x1e";
    /**
     * Instances with customizable hardware acceleration, 1st generation
     */
    InstanceClass["FPGA1"] = "f1";
    /**
     * Instances with customizable hardware acceleration, 1st generation
     */
    InstanceClass["F1"] = "f1";
    /**
     * Graphics-optimized instances, 3rd generation
     */
    InstanceClass["GRAPHICS3"] = "g3";
    /**
     * Graphics-optimized instances, 3rd generation
     */
    InstanceClass["G3"] = "g3";
    /**
     * Graphics-optimized instances with NVME drive for high performance computing, 4th generation
     */
    InstanceClass["GRAPHICS4_NVME_DRIVE_HIGH_PERFORMANCE"] = "g4dn";
    /**
     * Graphics-optimized instances with NVME drive for high performance computing, 4th generation
     */
    InstanceClass["G4DN"] = "g4dn";
    /**
     * Parallel-processing optimized instances, 2nd generation
     */
    InstanceClass["PARALLEL2"] = "p2";
    /**
     * Parallel-processing optimized instances, 2nd generation
     */
    InstanceClass["P2"] = "p2";
    /**
     * Parallel-processing optimized instances, 3nd generation
     */
    InstanceClass["PARALLEL3"] = "p3";
    /**
     * Parallel-processing optimized instances, 3nd generation
     */
    InstanceClass["P3"] = "p3";
    /**
     * Arm processor based instances, 1st generation
     */
    InstanceClass["ARM1"] = "a1";
    /**
     * Arm processor based instances, 1st generation
     */
    InstanceClass["A1"] = "a1";
    /**
     * Arm processor based instances, 2nd generation
     */
    InstanceClass["STANDARD6_GRAVITON"] = "m6g";
    /**
     * Arm processor based instances, 2nd generation
     */
    InstanceClass["M6G"] = "m6g";
    /**
     * High memory and compute capacity instances, 1st generation
     */
    InstanceClass["HIGH_COMPUTE_MEMORY1"] = "z1d";
    /**
     * High memory and compute capacity instances, 1st generation
     */
    InstanceClass["Z1D"] = "z1d";
    /**
     * Inferentia Chips based instances for machine learning inference applications, 1st generation
     */
    InstanceClass["INFERENCE1"] = "inf1";
    /**
     * Inferentia Chips based instances for machine learning inference applications, 1st generation
     */
    InstanceClass["INF1"] = "inf1";
})(InstanceClass = exports.InstanceClass || (exports.InstanceClass = {}));
/**
 * What size of instance to use
 */
var InstanceSize;
(function (InstanceSize) {
    InstanceSize["NANO"] = "nano";
    InstanceSize["MICRO"] = "micro";
    InstanceSize["SMALL"] = "small";
    InstanceSize["MEDIUM"] = "medium";
    InstanceSize["LARGE"] = "large";
    InstanceSize["XLARGE"] = "xlarge";
    InstanceSize["XLARGE2"] = "2xlarge";
    InstanceSize["XLARGE4"] = "4xlarge";
    InstanceSize["XLARGE8"] = "8xlarge";
    InstanceSize["XLARGE9"] = "9xlarge";
    InstanceSize["XLARGE10"] = "10xlarge";
    InstanceSize["XLARGE12"] = "12xlarge";
    InstanceSize["XLARGE16"] = "16xlarge";
    InstanceSize["XLARGE18"] = "18xlarge";
    InstanceSize["XLARGE24"] = "24xlarge";
    InstanceSize["XLARGE32"] = "32xlarge";
    InstanceSize["METAL"] = "metal";
})(InstanceSize = exports.InstanceSize || (exports.InstanceSize = {}));
/**
 * Instance type for EC2 instances
 *
 * This class takes a literal string, good if you already
 * know the identifier of the type you want.
 */
class InstanceType {
    constructor(instanceTypeIdentifier) {
        this.instanceTypeIdentifier = instanceTypeIdentifier;
    }
    /**
     * Instance type for EC2 instances
     *
     * This class takes a combination of a class and size.
     *
     * Be aware that not all combinations of class and size are available, and not all
     * classes are available in all regions.
     */
    static of(instanceClass, instanceSize) {
        return new InstanceType(`${instanceClass}.${instanceSize}`);
    }
    /**
     * Return the instance type as a dotted string
     */
    toString() {
        return this.instanceTypeIdentifier;
    }
}
exports.InstanceType = InstanceType;
//# sourceMappingURL=data:application/json;base64,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