"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// Copyright 2012-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// tslint:disable:max-line-length | This is generated code - line lengths are difficult to control
const cloudwatch = require("../../aws-cloudwatch"); // Automatically re-written from '@aws-cdk/aws-cloudwatch'
const vpn_1 = require("./vpn");
vpn_1.VpnConnection.prototype.metric = function (metricName, props) {
    return new cloudwatch.Metric({
        namespace: 'AWS/VPN',
        metricName,
        dimensions: { VpnId: this.vpnId },
        ...props
    }).attachTo(this);
};
vpn_1.VpnConnection.prototype.metricTunnelState = function (props) {
    return this.metric('TunnelState', { statistic: 'Average', ...props });
};
vpn_1.VpnConnection.prototype.metricTunnelDataIn = function (props) {
    return this.metric('TunnelDataIn', { statistic: 'Sum', ...props });
};
vpn_1.VpnConnection.prototype.metricTunnelDataOut = function (props) {
    return this.metric('TunnelDataOut', { statistic: 'Sum', ...props });
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZWMyLWF1Z21lbnRhdGlvbnMuZ2VuZXJhdGVkLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiZWMyLWF1Z21lbnRhdGlvbnMuZ2VuZXJhdGVkLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsK0VBQStFO0FBQy9FLGtHQUFrRztBQUNsRyxtREFBbUQsQ0FBQywwREFBMEQ7QUFDOUcsK0JBQXNDO0FBbUR0QyxtQkFBYSxDQUFDLFNBQVMsQ0FBQyxNQUFNLEdBQUcsVUFBVSxVQUFrQixFQUFFLEtBQWdDO0lBQzNGLE9BQU8sSUFBSSxVQUFVLENBQUMsTUFBTSxDQUFDO1FBQ3pCLFNBQVMsRUFBRSxTQUFTO1FBQ3BCLFVBQVU7UUFDVixVQUFVLEVBQUUsRUFBRSxLQUFLLEVBQUUsSUFBSSxDQUFDLEtBQUssRUFBRTtRQUNqQyxHQUFHLEtBQUs7S0FDWCxDQUFDLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxDQUFDO0FBQ3RCLENBQUMsQ0FBQztBQUNGLG1CQUFhLENBQUMsU0FBUyxDQUFDLGlCQUFpQixHQUFHLFVBQVUsS0FBZ0M7SUFDbEYsT0FBTyxJQUFJLENBQUMsTUFBTSxDQUFDLGFBQWEsRUFBRSxFQUFFLFNBQVMsRUFBRSxTQUFTLEVBQUUsR0FBRyxLQUFLLEVBQUUsQ0FBQyxDQUFDO0FBQzFFLENBQUMsQ0FBQztBQUNGLG1CQUFhLENBQUMsU0FBUyxDQUFDLGtCQUFrQixHQUFHLFVBQVUsS0FBZ0M7SUFDbkYsT0FBTyxJQUFJLENBQUMsTUFBTSxDQUFDLGNBQWMsRUFBRSxFQUFFLFNBQVMsRUFBRSxLQUFLLEVBQUUsR0FBRyxLQUFLLEVBQUUsQ0FBQyxDQUFDO0FBQ3ZFLENBQUMsQ0FBQztBQUNGLG1CQUFhLENBQUMsU0FBUyxDQUFDLG1CQUFtQixHQUFHLFVBQVUsS0FBZ0M7SUFDcEYsT0FBTyxJQUFJLENBQUMsTUFBTSxDQUFDLGVBQWUsRUFBRSxFQUFFLFNBQVMsRUFBRSxLQUFLLEVBQUUsR0FBRyxLQUFLLEVBQUUsQ0FBQyxDQUFDO0FBQ3hFLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIENvcHlyaWdodCAyMDEyLTIwMjAgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbi8vIHRzbGludDpkaXNhYmxlOm1heC1saW5lLWxlbmd0aCB8IFRoaXMgaXMgZ2VuZXJhdGVkIGNvZGUgLSBsaW5lIGxlbmd0aHMgYXJlIGRpZmZpY3VsdCB0byBjb250cm9sXG5pbXBvcnQgKiBhcyBjbG91ZHdhdGNoIGZyb20gXCIuLi8uLi9hd3MtY2xvdWR3YXRjaFwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvYXdzLWNsb3Vkd2F0Y2gnXG5pbXBvcnQgeyBWcG5Db25uZWN0aW9uIH0gZnJvbSBcIi4vdnBuXCI7XG5kZWNsYXJlIG1vZHVsZSBcIi4vdnBuXCIge1xuICAgIGludGVyZmFjZSBJVnBuQ29ubmVjdGlvbiB7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBSZXR1cm4gdGhlIGdpdmVuIG5hbWVkIG1ldHJpYyBmb3IgdGhpcyBWUE5Db25uZWN0aW9uXG4gICAgICAgICAqL1xuICAgICAgICBtZXRyaWMobWV0cmljTmFtZTogc3RyaW5nLCBwcm9wcz86IGNsb3Vkd2F0Y2guTWV0cmljT3B0aW9ucyk6IGNsb3Vkd2F0Y2guTWV0cmljO1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIHN0YXRlIG9mIHRoZSB0dW5uZWwuIDAgaW5kaWNhdGVzIERPV04gYW5kIDEgaW5kaWNhdGVzIFVQLlxuICAgICAgICAgKlxuICAgICAgICAgKiBBdmVyYWdlIG92ZXIgNSBtaW51dGVzXG4gICAgICAgICAqL1xuICAgICAgICBtZXRyaWNUdW5uZWxTdGF0ZShwcm9wcz86IGNsb3Vkd2F0Y2guTWV0cmljT3B0aW9ucyk6IGNsb3Vkd2F0Y2guTWV0cmljO1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIGJ5dGVzIHJlY2VpdmVkIHRocm91Z2ggdGhlIFZQTiB0dW5uZWwuXG4gICAgICAgICAqXG4gICAgICAgICAqIFN1bSBvdmVyIDUgbWludXRlc1xuICAgICAgICAgKi9cbiAgICAgICAgbWV0cmljVHVubmVsRGF0YUluKHByb3BzPzogY2xvdWR3YXRjaC5NZXRyaWNPcHRpb25zKTogY2xvdWR3YXRjaC5NZXRyaWM7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBUaGUgYnl0ZXMgc2VudCB0aHJvdWdoIHRoZSBWUE4gdHVubmVsLlxuICAgICAgICAgKlxuICAgICAgICAgKiBTdW0gb3ZlciA1IG1pbnV0ZXNcbiAgICAgICAgICovXG4gICAgICAgIG1ldHJpY1R1bm5lbERhdGFPdXQocHJvcHM/OiBjbG91ZHdhdGNoLk1ldHJpY09wdGlvbnMpOiBjbG91ZHdhdGNoLk1ldHJpYztcbiAgICB9XG4gICAgaW50ZXJmYWNlIFZwbkNvbm5lY3Rpb24ge1xuICAgICAgICAvKipcbiAgICAgICAgICogUmV0dXJuIHRoZSBnaXZlbiBuYW1lZCBtZXRyaWMgZm9yIHRoaXMgVlBOQ29ubmVjdGlvblxuICAgICAgICAgKi9cbiAgICAgICAgbWV0cmljKG1ldHJpY05hbWU6IHN0cmluZywgcHJvcHM/OiBjbG91ZHdhdGNoLk1ldHJpY09wdGlvbnMpOiBjbG91ZHdhdGNoLk1ldHJpYztcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBzdGF0ZSBvZiB0aGUgdHVubmVsLiAwIGluZGljYXRlcyBET1dOIGFuZCAxIGluZGljYXRlcyBVUC5cbiAgICAgICAgICpcbiAgICAgICAgICogQXZlcmFnZSBvdmVyIDUgbWludXRlc1xuICAgICAgICAgKi9cbiAgICAgICAgbWV0cmljVHVubmVsU3RhdGUocHJvcHM/OiBjbG91ZHdhdGNoLk1ldHJpY09wdGlvbnMpOiBjbG91ZHdhdGNoLk1ldHJpYztcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBieXRlcyByZWNlaXZlZCB0aHJvdWdoIHRoZSBWUE4gdHVubmVsLlxuICAgICAgICAgKlxuICAgICAgICAgKiBTdW0gb3ZlciA1IG1pbnV0ZXNcbiAgICAgICAgICovXG4gICAgICAgIG1ldHJpY1R1bm5lbERhdGFJbihwcm9wcz86IGNsb3Vkd2F0Y2guTWV0cmljT3B0aW9ucyk6IGNsb3Vkd2F0Y2guTWV0cmljO1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIGJ5dGVzIHNlbnQgdGhyb3VnaCB0aGUgVlBOIHR1bm5lbC5cbiAgICAgICAgICpcbiAgICAgICAgICogU3VtIG92ZXIgNSBtaW51dGVzXG4gICAgICAgICAqL1xuICAgICAgICBtZXRyaWNUdW5uZWxEYXRhT3V0KHByb3BzPzogY2xvdWR3YXRjaC5NZXRyaWNPcHRpb25zKTogY2xvdWR3YXRjaC5NZXRyaWM7XG4gICAgfVxufVxuVnBuQ29ubmVjdGlvbi5wcm90b3R5cGUubWV0cmljID0gZnVuY3Rpb24gKG1ldHJpY05hbWU6IHN0cmluZywgcHJvcHM/OiBjbG91ZHdhdGNoLk1ldHJpY09wdGlvbnMpIHtcbiAgICByZXR1cm4gbmV3IGNsb3Vkd2F0Y2guTWV0cmljKHtcbiAgICAgICAgbmFtZXNwYWNlOiAnQVdTL1ZQTicsXG4gICAgICAgIG1ldHJpY05hbWUsXG4gICAgICAgIGRpbWVuc2lvbnM6IHsgVnBuSWQ6IHRoaXMudnBuSWQgfSxcbiAgICAgICAgLi4ucHJvcHNcbiAgICB9KS5hdHRhY2hUbyh0aGlzKTtcbn07XG5WcG5Db25uZWN0aW9uLnByb3RvdHlwZS5tZXRyaWNUdW5uZWxTdGF0ZSA9IGZ1bmN0aW9uIChwcm9wcz86IGNsb3Vkd2F0Y2guTWV0cmljT3B0aW9ucykge1xuICAgIHJldHVybiB0aGlzLm1ldHJpYygnVHVubmVsU3RhdGUnLCB7IHN0YXRpc3RpYzogJ0F2ZXJhZ2UnLCAuLi5wcm9wcyB9KTtcbn07XG5WcG5Db25uZWN0aW9uLnByb3RvdHlwZS5tZXRyaWNUdW5uZWxEYXRhSW4gPSBmdW5jdGlvbiAocHJvcHM/OiBjbG91ZHdhdGNoLk1ldHJpY09wdGlvbnMpIHtcbiAgICByZXR1cm4gdGhpcy5tZXRyaWMoJ1R1bm5lbERhdGFJbicsIHsgc3RhdGlzdGljOiAnU3VtJywgLi4ucHJvcHMgfSk7XG59O1xuVnBuQ29ubmVjdGlvbi5wcm90b3R5cGUubWV0cmljVHVubmVsRGF0YU91dCA9IGZ1bmN0aW9uIChwcm9wcz86IGNsb3Vkd2F0Y2guTWV0cmljT3B0aW9ucykge1xuICAgIHJldHVybiB0aGlzLm1ldHJpYygnVHVubmVsRGF0YU91dCcsIHsgc3RhdGlzdGljOiAnU3VtJywgLi4ucHJvcHMgfSk7XG59O1xuIl19