"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const codepipeline = require("../../aws-codepipeline"); // Automatically re-written from '@aws-cdk/aws-codepipeline'
const sns = require("../../aws-sns"); // Automatically re-written from '@aws-cdk/aws-sns'
const subs = require("../../aws-sns-subscriptions"); // Automatically re-written from '@aws-cdk/aws-sns-subscriptions'
const action_1 = require("./action");
/**
 * Manual approval action.
 */
class ManualApprovalAction extends action_1.Action {
    constructor(props) {
        super({
            ...props,
            category: codepipeline.ActionCategory.APPROVAL,
            provider: 'Manual',
            artifactBounds: { minInputs: 0, maxInputs: 0, minOutputs: 0, maxOutputs: 0 },
        });
        this.props = props;
    }
    get notificationTopic() {
        return this._notificationTopic;
    }
    bound(scope, _stage, options) {
        var _a;
        if (this.props.notificationTopic) {
            this._notificationTopic = this.props.notificationTopic;
        }
        else if ((this.props.notifyEmails || []).length > 0) {
            this._notificationTopic = new sns.Topic(scope, 'TopicResource');
        }
        if (this._notificationTopic) {
            this._notificationTopic.grantPublish(options.role);
            for (const notifyEmail of this.props.notifyEmails || []) {
                this._notificationTopic.addSubscription(new subs.EmailSubscription(notifyEmail));
            }
        }
        return {
            configuration: undefinedIfAllValuesAreEmpty({
                NotificationArn: (_a = this._notificationTopic) === null || _a === void 0 ? void 0 : _a.topicArn,
                CustomData: this.props.additionalInformation,
                ExternalEntityLink: this.props.externalEntityLink,
            }),
        };
    }
}
exports.ManualApprovalAction = ManualApprovalAction;
function undefinedIfAllValuesAreEmpty(object) {
    return Object.values(object).some(v => v !== undefined) ? object : undefined;
}
//# sourceMappingURL=data:application/json;base64,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