"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const codepipeline = require("../../../aws-codepipeline"); // Automatically re-written from '@aws-cdk/aws-codepipeline'
const action_1 = require("../action");
const jenkins_provider_1 = require("./jenkins-provider");
/**
 * The type of the Jenkins Action that determines its CodePipeline Category -
 * Build, or Test.
 * Note that a Jenkins provider, even if it has the same name,
 * must be separately registered for each type.
 */
var JenkinsActionType;
(function (JenkinsActionType) {
    /**
     * The Action will have the Build Category.
     */
    JenkinsActionType[JenkinsActionType["BUILD"] = 0] = "BUILD";
    /**
     * The Action will have the Test Category.
     */
    JenkinsActionType[JenkinsActionType["TEST"] = 1] = "TEST";
})(JenkinsActionType = exports.JenkinsActionType || (exports.JenkinsActionType = {}));
/**
 * Jenkins build CodePipeline Action.
 *
 * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/tutorials-four-stage-pipeline.html
 */
class JenkinsAction extends action_1.Action {
    constructor(props) {
        super({
            ...props,
            category: props.type === JenkinsActionType.BUILD
                ? codepipeline.ActionCategory.BUILD
                : codepipeline.ActionCategory.TEST,
            provider: props.jenkinsProvider.providerName,
            owner: 'Custom',
            artifactBounds: jenkins_provider_1.jenkinsArtifactsBounds,
            version: props.jenkinsProvider.version,
        });
        this.props = props;
    }
    bound(_scope, _stage, _options) {
        if (this.actionProperties.category === codepipeline.ActionCategory.BUILD) {
            this.props.jenkinsProvider._registerBuildProvider();
        }
        else {
            this.props.jenkinsProvider._registerTestProvider();
        }
        return {
            configuration: {
                ProjectName: this.props.projectName,
            },
        };
    }
}
exports.JenkinsAction = JenkinsAction;
//# sourceMappingURL=data:application/json;base64,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