"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const events = require("../../aws-events"); // Automatically re-written from '@aws-cdk/aws-events'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * Low-level class for generic CodePipeline Actions.
 *
 * WARNING: this class should not be externally exposed, but is currently visible
 * because of a limitation of jsii (https://github.com/aws/jsii/issues/524).
 *
 * This class will disappear in a future release and should not be used.
 *
 * @experimental
 */
class Action {
    constructor(actionProperties) {
        this.variableReferenced = false;
        this.customerProvidedNamespace = actionProperties.variablesNamespace;
        this.namespaceOrToken = core_1.Lazy.stringValue({ produce: () => {
                // make sure the action was bound (= added to a pipeline)
                if (this.actualNamespace !== undefined) {
                    return this.customerProvidedNamespace !== undefined
                        // if a customer passed a namespace explicitly, always use that
                        ? this.customerProvidedNamespace
                        // otherwise, only return a namespace if any variable was referenced
                        : (this.variableReferenced ? this.actualNamespace : undefined);
                }
                else {
                    throw new Error(`Cannot reference variables of action '${this.actionProperties.actionName}', ` +
                        'as that action was never added to a pipeline');
                }
            } });
        this.actionProperties = {
            ...actionProperties,
            variablesNamespace: this.namespaceOrToken,
        };
    }
    bind(scope, stage, options) {
        this._pipeline = stage.pipeline;
        this._stage = stage;
        this._scope = scope;
        this.actualNamespace = this.customerProvidedNamespace === undefined
            // default a namespace name, based on the stage and action names
            ? `${stage.stageName}_${this.actionProperties.actionName}_NS`
            : this.customerProvidedNamespace;
        return this.bound(scope, stage, options);
    }
    onStateChange(name, target, options) {
        const rule = new events.Rule(this.scope, name, options);
        rule.addTarget(target);
        rule.addEventPattern({
            detailType: ['CodePipeline Action Execution State Change'],
            source: ['aws.codepipeline'],
            resources: [this.pipeline.pipelineArn],
            detail: {
                stage: [this.stage.stageName],
                action: [this.actionProperties.actionName],
            },
        });
        return rule;
    }
    variableExpression(variableName) {
        this.variableReferenced = true;
        return `#{${this.namespaceOrToken}.${variableName}}`;
    }
    get pipeline() {
        if (this._pipeline) {
            return this._pipeline;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline before using onStateChange');
        }
    }
    get stage() {
        if (this._stage) {
            return this._stage;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline before using onStateChange');
        }
    }
    /**
     * Retrieves the Construct scope of this Action.
     * Only available after the Action has been added to a Stage,
     * and that Stage to a Pipeline.
     */
    get scope() {
        if (this._scope) {
            return this._scope;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline first');
        }
    }
}
exports.Action = Action;
//# sourceMappingURL=data:application/json;base64,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