"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const utils_1 = require("../utils");
const deployment_config_1 = require("./deployment-config");
/**
 * Note: This class currently stands as a namespaced container for importing an ECS
 * Deployment Group defined outside the CDK app until CloudFormation supports provisioning
 * ECS Deployment Groups. Until then it is closed (private constructor) and does not
 * extend {@link cdk.Construct}.
 *
 * @resource AWS::CodeDeploy::DeploymentGroup
 */
class EcsDeploymentGroup {
    /**
     * Import an ECS Deployment Group defined outside the CDK app.
     *
     * @param scope the parent Construct for this new Construct
     * @param id the logical ID of this new Construct
     * @param attrs the properties of the referenced Deployment Group
     * @returns a Construct representing a reference to an existing Deployment Group
     */
    static fromEcsDeploymentGroupAttributes(scope, id, attrs) {
        return new ImportedEcsDeploymentGroup(scope, id, attrs);
    }
    constructor() {
        // nothing to do until CFN supports ECS deployment groups
    }
}
exports.EcsDeploymentGroup = EcsDeploymentGroup;
class ImportedEcsDeploymentGroup extends cdk.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        this.application = props.application;
        this.deploymentGroupName = props.deploymentGroupName;
        this.deploymentGroupArn = utils_1.arnForDeploymentGroup(props.application.applicationName, props.deploymentGroupName);
        this.deploymentConfig = props.deploymentConfig || deployment_config_1.EcsDeploymentConfig.ALL_AT_ONCE;
    }
}
//# sourceMappingURL=data:application/json;base64,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