"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Artifacts definition for a CodeBuild Project.
 */
class Artifacts {
    constructor(props) {
        this.identifier = props.identifier;
    }
    static s3(props) {
        return new S3Artifacts(props);
    }
    bind(_scope, _project) {
        return {
            artifactsProperty: {
                artifactIdentifier: this.identifier,
                type: this.type,
            },
        };
    }
}
exports.Artifacts = Artifacts;
/**
 * S3 Artifact definition for a CodeBuild Project.
 */
class S3Artifacts extends Artifacts {
    constructor(props) {
        super(props);
        this.props = props;
        this.type = 'S3';
    }
    bind(_scope, project) {
        this.props.bucket.grantReadWrite(project);
        const superConfig = super.bind(_scope, project);
        return {
            artifactsProperty: {
                ...superConfig.artifactsProperty,
                location: this.props.bucket.bucketName,
                path: this.props.path,
                namespaceType: this.props.includeBuildId === false ? 'NONE' : 'BUILD_ID',
                name: this.props.name == null ? undefined : this.props.name,
                packaging: this.props.packageZip === false ? 'NONE' : 'ZIP',
                encryptionDisabled: this.props.encryption === false ? true : undefined,
                overrideArtifactName: this.props.name == null ? true : undefined,
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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