"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * Make a Token that renders to given region if used in a different stack, otherwise undefined
 */
function regionIfDifferentFromStack(region) {
    return cdk.Token.asString(new StackDependentToken(region, stack => stack.region));
}
exports.regionIfDifferentFromStack = regionIfDifferentFromStack;
/**
 * Make a Token that renders to given account if used in a different stack, otherwise undefined
 */
function accountIfDifferentFromStack(account) {
    return cdk.Token.asString(new StackDependentToken(account, stack => stack.account));
}
exports.accountIfDifferentFromStack = accountIfDifferentFromStack;
/**
 * A lazy token that requires an instance of Stack to evaluate
 */
class StackDependentToken {
    constructor(originalValue, fn) {
        this.originalValue = originalValue;
        this.fn = fn;
        this.creationStack = cdk.captureStackTrace();
    }
    resolve(context) {
        const stackValue = this.fn(cdk.Stack.of(context.scope));
        // Don't render if the values are definitely the same. If the stack
        // is unresolved we don't know, better output the value.
        if (!cdk.Token.isUnresolved(stackValue) && stackValue === this.originalValue) {
            return undefined;
        }
        return this.originalValue;
    }
    toString() {
        return cdk.Token.asString(this);
    }
    toJSON() {
        return this.originalValue;
    }
}
//# sourceMappingURL=data:application/json;base64,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