"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const object_1 = require("./object");
/**
 * A Token object that will drop the last element of an array if it is an empty object
 *
 * Necessary to prevent options objects that only contain "region" and "account" keys
 * that evaluate to "undefined" from showing up in the rendered JSON.
 */
class DropEmptyObjectAtTheEndOfAnArray {
    constructor(value) {
        this.value = value;
        this.creationStack = cdk.captureStackTrace();
    }
    resolve(context) {
        context.registerPostProcessor(this);
        return context.resolve(this.value);
    }
    postProcess(o, _context) {
        if (!Array.isArray(o)) {
            return o;
        }
        const lastEl = o[o.length - 1];
        if (typeof lastEl === 'object' && lastEl !== null && Object.keys(object_1.dropUndefined(lastEl)).length === 0) {
            return o.slice(0, o.length - 1);
        }
        return o;
    }
}
exports.DropEmptyObjectAtTheEndOfAnArray = DropEmptyObjectAtTheEndOfAnArray;
//# sourceMappingURL=data:application/json;base64,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