"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Statistic to use over the aggregation period
 */
var Statistic;
(function (Statistic) {
    /**
     * The count (number) of data points used for the statistical calculation.
     */
    Statistic["SAMPLE_COUNT"] = "SampleCount";
    /**
     * The value of Sum / SampleCount during the specified period.
     */
    Statistic["AVERAGE"] = "Average";
    /**
     * All values submitted for the matching metric added together.
     * This statistic can be useful for determining the total volume of a metric.
     */
    Statistic["SUM"] = "Sum";
    /**
     * The lowest value observed during the specified period.
     * You can use this value to determine low volumes of activity for your application.
     */
    Statistic["MINIMUM"] = "Minimum";
    /**
     * The highest value observed during the specified period.
     * You can use this value to determine high volumes of activity for your application.
     */
    Statistic["MAXIMUM"] = "Maximum";
})(Statistic = exports.Statistic || (exports.Statistic = {}));
/**
 * Unit for metric
 */
var Unit;
(function (Unit) {
    /**
     * Seconds
     */
    Unit["SECONDS"] = "Seconds";
    /**
     * Microseconds
     */
    Unit["MICROSECONDS"] = "Microseconds";
    /**
     * Milliseconds
     */
    Unit["MILLISECONDS"] = "Milliseconds";
    /**
     * Bytes
     */
    Unit["BYTES"] = "Bytes";
    /**
     * Kilobytes
     */
    Unit["KILOBYTES"] = "Kilobytes";
    /**
     * Megabytes
     */
    Unit["MEGABYTES"] = "Megabytes";
    /**
     * Gigabytes
     */
    Unit["GIGABYTES"] = "Gigabytes";
    /**
     * Terabytes
     */
    Unit["TERABYTES"] = "Terabytes";
    /**
     * Bits
     */
    Unit["BITS"] = "Bits";
    /**
     * Kilobits
     */
    Unit["KILOBITS"] = "Kilobits";
    /**
     * Megabits
     */
    Unit["MEGABITS"] = "Megabits";
    /**
     * Gigabits
     */
    Unit["GIGABITS"] = "Gigabits";
    /**
     * Terabits
     */
    Unit["TERABITS"] = "Terabits";
    /**
     * Percent
     */
    Unit["PERCENT"] = "Percent";
    /**
     * Count
     */
    Unit["COUNT"] = "Count";
    /**
     * Bytes/second (B/s)
     */
    Unit["BYTES_PER_SECOND"] = "Bytes/Second";
    /**
     * Kilobytes/second (kB/s)
     */
    Unit["KILOBYTES_PER_SECOND"] = "Kilobytes/Second";
    /**
     * Megabytes/second (MB/s)
     */
    Unit["MEGABYTES_PER_SECOND"] = "Megabytes/Second";
    /**
     * Gigabytes/second (GB/s)
     */
    Unit["GIGABYTES_PER_SECOND"] = "Gigabytes/Second";
    /**
     * Terabytes/second (TB/s)
     */
    Unit["TERABYTES_PER_SECOND"] = "Terabytes/Second";
    /**
     * Bits/second (b/s)
     */
    Unit["BITS_PER_SECOND"] = "Bits/Second";
    /**
     * Kilobits/second (kb/s)
     */
    Unit["KILOBITS_PER_SECOND"] = "Kilobits/Second";
    /**
     * Megabits/second (Mb/s)
     */
    Unit["MEGABITS_PER_SECOND"] = "Megabits/Second";
    /**
     * Gigabits/second (Gb/s)
     */
    Unit["GIGABITS_PER_SECOND"] = "Gigabits/Second";
    /**
     * Terabits/second (Tb/s)
     */
    Unit["TERABITS_PER_SECOND"] = "Terabits/Second";
    /**
     * Count/second
     */
    Unit["COUNT_PER_SECOND"] = "Count/Second";
    /**
     * No unit
     */
    Unit["NONE"] = "None";
})(Unit = exports.Unit || (exports.Unit = {}));
//# sourceMappingURL=data:application/json;base64,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