"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Capabilities that affect whether CloudFormation is allowed to change IAM resources
 * @deprecated use `core.CfnCapabilities`
 */
var CloudFormationCapabilities;
(function (CloudFormationCapabilities) {
    /**
     * No IAM Capabilities
     *
     * Pass this capability if you wish to block the creation IAM resources.
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-capabilities
     */
    CloudFormationCapabilities["NONE"] = "";
    /**
     * Capability to create anonymous IAM resources
     *
     * Pass this capability if you're only creating anonymous resources.
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-capabilities
     */
    CloudFormationCapabilities["ANONYMOUS_IAM"] = "CAPABILITY_IAM";
    /**
     * Capability to create named IAM resources.
     *
     * Pass this capability if you're creating IAM resources that have physical
     * names.
     *
     * `CloudFormationCapabilities.NamedIAM` implies `CloudFormationCapabilities.IAM`; you don't have to pass both.
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-capabilities
     */
    CloudFormationCapabilities["NAMED_IAM"] = "CAPABILITY_NAMED_IAM";
    /**
     * Capability to run CloudFormation macros
     *
     * Pass this capability if your template includes macros, for example AWS::Include or AWS::Serverless.
     *
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateStack.html
     */
    CloudFormationCapabilities["AUTO_EXPAND"] = "CAPABILITY_AUTO_EXPAND";
})(CloudFormationCapabilities = exports.CloudFormationCapabilities || (exports.CloudFormationCapabilities = {}));
//# sourceMappingURL=data:application/json;base64,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