import * as ec2 from "../../aws-ec2";
import * as cdk from "../../core";
/**
 * A Cloud9 Environment
 *
 */
export interface IEc2Environment extends cdk.IResource {
    /**
     * The name of the EnvironmentEc2
     *
     * @attribute environmentEc2Name
     */
    readonly ec2EnvironmentName: string;
    /**
     * The arn of the EnvironmentEc2
     *
     * @attribute environmentE2Arn
     */
    readonly ec2EnvironmentArn: string;
}
/**
 * Properties for Ec2Environment
 */
export interface Ec2EnvironmentProps {
    /**
     * The type of instance to connect to the environment.
     *
     * @default - t2.micro
     */
    readonly instanceType?: ec2.InstanceType;
    /**
     * The subnetSelection of the VPC that AWS Cloud9 will use to communicate with
     * the Amazon EC2 instance.
     *
     * @default - all public subnets of the VPC are selected.
     */
    readonly subnetSelection?: ec2.SubnetSelection;
    /**
     * The VPC that AWS Cloud9 will use to communicate with the Amazon Elastic Compute Cloud (Amazon EC2) instance.
     *
     */
    readonly vpc: ec2.IVpc;
    /**
     * Name of the environment
     *
     * @default - automatically generated name
     */
    readonly ec2EnvironmentName?: string;
    /**
     * Description of the environment
     *
     * @default - no description
     */
    readonly description?: string;
}
/**
 * A Cloud9 Environment with Amazon EC2
 * @resource AWS::Cloud9::EnvironmentEC2
 */
export declare class Ec2Environment extends cdk.Resource implements IEc2Environment {
    /**
     * import from EnvironmentEc2Name
     */
    static fromEc2EnvironmentName(scope: cdk.Construct, id: string, ec2EnvironmentName: string): IEc2Environment;
    /**
     * The environment name of this Cloud9 environment
     *
     * @attribute
     */
    readonly ec2EnvironmentName: string;
    /**
     * The environment ARN of this Cloud9 environment
     *
     * @attribute
     */
    readonly ec2EnvironmentArn: string;
    /**
     * The environment ID of this Cloud9 environment
     */
    readonly environmentId: string;
    /**
     * The complete IDE URL of this Cloud9 environment
     */
    readonly ideUrl: string;
    /**
     * VPC ID
     */
    readonly vpc: ec2.IVpc;
    constructor(scope: cdk.Construct, id: string, props: Ec2EnvironmentProps);
}
