"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const public_suffixes_1 = require("./public-suffixes");
/**
 * Returns the apex domain (domain.com) from a subdomain (www.sub.domain.com)
 */
function apexDomain(domainName) {
    const parts = domainName.split('.').reverse();
    let curr = public_suffixes_1.publicSuffixes;
    const accumulated = [];
    for (const part of parts) {
        accumulated.push(part);
        if (!(part in curr)) {
            break;
        }
        curr = curr[part];
    }
    return accumulated.reverse().join('.');
}
exports.apexDomain = apexDomain;
function isDnsValidatedCertificate(cert) {
    return cert.hasOwnProperty('domainName');
}
exports.isDnsValidatedCertificate = isDnsValidatedCertificate;
function getCertificateRegion(cert) {
    const { certificateArn, stack } = cert;
    if (isDnsValidatedCertificate(cert)) {
        const requestResource = cert.node.findChild('CertificateRequestorResource').node.defaultChild;
        // @ts-ignore
        const { _cfnProperties: properties } = requestResource;
        const { Region: region } = properties;
        if (region && !core_1.Token.isUnresolved(region)) {
            return region;
        }
    }
    {
        const { region } = core_1.Arn.parse(certificateArn);
        if (region && !core_1.Token.isUnresolved(region)) {
            return region;
        }
    }
    return core_1.Stack.of(stack).region;
}
exports.getCertificateRegion = getCertificateRegion;
//# sourceMappingURL=data:application/json;base64,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