"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ecs = require("../../aws-ecs"); // Automatically re-written from '@aws-cdk/aws-ecs'
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
/**
 * Batch Job Task Definition
 *
 * Defines a Batch Job Task Definition. The properties of this task definition mirrors
 * those of an {@link ecs.ContainerDefinition}. This class is a wrapper on that structure.
 */
class TaskDefinition {
    constructor(props) {
        this.executionRole = props.executionRole;
    }
    /**
     * Internal function to allow the Batch Job task defintion
     * to match the CDK requirements of an EC2 task definition.
     *
     * @internal
     */
    // tslint:disable-next-line: no-empty
    _linkContainer() { }
    /**
     * Retrieves the execution role for this task definition
     */
    obtainExecutionRole() {
        return this.executionRole;
    }
}
/**
 * The configuration for creating a batch container image.
 */
class JobDefinitionImageConfig {
    constructor(scope, container) {
        const config = this.bindImageConfig(scope, container);
        this.imageName = config.imageName;
    }
    bindImageConfig(scope, container) {
        return container.image.bind(scope, new ecs.ContainerDefinition(scope, 'Resource-Batch-Job-Container-Definition', {
            command: container.command,
            cpu: container.vcpus,
            image: container.image,
            environment: container.environment,
            linuxParameters: container.linuxParams,
            memoryLimitMiB: container.memoryLimitMiB,
            privileged: container.privileged,
            readonlyRootFilesystem: container.readOnly,
            gpuCount: container.gpuCount,
            user: container.user,
            taskDefinition: new TaskDefinition({
                executionRole: container.jobRole || new iam.LazyRole(scope, 'Resource-Batch-Task-Definition-Role', {
                    assumedBy: new iam.ServicePrincipal('batch.amazonaws.com'),
                }),
            }),
        }));
    }
}
exports.JobDefinitionImageConfig = JobDefinitionImageConfig;
//# sourceMappingURL=data:application/json;base64,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