"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const dynamodb = require("../../aws-dynamodb"); // Automatically re-written from '@aws-cdk/aws-dynamodb'
const ec2 = require("../../aws-ec2"); // Automatically re-written from '@aws-cdk/aws-ec2'
const efs = require("../../aws-efs"); // Automatically re-written from '@aws-cdk/aws-efs'
const rds = require("../../aws-rds"); // Automatically re-written from '@aws-cdk/aws-rds'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
class BackupableResourcesCollector {
    constructor() {
        this.resources = [];
    }
    visit(node) {
        if (node instanceof efs.CfnFileSystem) {
            this.resources.push(core_1.Stack.of(node).formatArn({
                service: 'elasticfilesystem',
                resource: 'file-system',
                resourceName: node.ref,
            }));
        }
        if (node instanceof dynamodb.CfnTable) {
            this.resources.push(core_1.Stack.of(node).formatArn({
                service: 'dynamodb',
                resource: 'table',
                resourceName: node.ref,
            }));
        }
        if (node instanceof ec2.CfnInstance) {
            this.resources.push(core_1.Stack.of(node).formatArn({
                service: 'ec2',
                resource: 'instance',
                resourceName: node.ref,
            }));
        }
        if (node instanceof ec2.CfnVolume) {
            this.resources.push(core_1.Stack.of(node).formatArn({
                service: 'ec2',
                resource: 'volume',
                resourceName: node.ref,
            }));
        }
        if (node instanceof rds.CfnDBInstance) {
            this.resources.push(core_1.Stack.of(node).formatArn({
                service: 'rds',
                resource: 'db',
                sep: ':',
                resourceName: node.ref,
            }));
        }
    }
}
exports.BackupableResourcesCollector = BackupableResourcesCollector;
//# sourceMappingURL=data:application/json;base64,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