"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const autoscaling_generated_1 = require("./autoscaling.generated");
/**
 * Define a scheduled scaling action
 */
class ScheduledAction extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        if (props.minCapacity === undefined && props.maxCapacity === undefined && props.desiredCapacity === undefined) {
            throw new Error('At least one of minCapacity, maxCapacity, or desiredCapacity is required');
        }
        new autoscaling_generated_1.CfnScheduledAction(this, 'Resource', {
            autoScalingGroupName: props.autoScalingGroup.autoScalingGroupName,
            startTime: formatISO(props.startTime),
            endTime: formatISO(props.endTime),
            minSize: props.minCapacity,
            maxSize: props.maxCapacity,
            desiredCapacity: props.desiredCapacity,
            recurrence: props.schedule.expressionString,
        });
    }
}
exports.ScheduledAction = ScheduledAction;
function formatISO(date) {
    if (!date) {
        return undefined;
    }
    return date.getUTCFullYear() +
        '-' + pad(date.getUTCMonth() + 1) +
        '-' + pad(date.getUTCDate()) +
        'T' + pad(date.getUTCHours()) +
        ':' + pad(date.getUTCMinutes()) +
        ':' + pad(date.getUTCSeconds()) +
        'Z';
    function pad(num) {
        if (num < 10) {
            return '0' + num;
        }
        return num;
    }
}
//# sourceMappingURL=data:application/json;base64,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