"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const autoscaling_generated_1 = require("./autoscaling.generated");
/**
 * Define a life cycle hook
 */
class LifecycleHook extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.lifecycleHookName,
        });
        this.role = props.role || new iam.Role(this, 'Role', {
            assumedBy: new iam.ServicePrincipal('autoscaling.amazonaws.com'),
        });
        const targetProps = props.notificationTarget.bind(this, this);
        const resource = new autoscaling_generated_1.CfnLifecycleHook(this, 'Resource', {
            autoScalingGroupName: props.autoScalingGroup.autoScalingGroupName,
            defaultResult: props.defaultResult,
            heartbeatTimeout: props.heartbeatTimeout && props.heartbeatTimeout.toSeconds(),
            lifecycleHookName: this.physicalName,
            lifecycleTransition: props.lifecycleTransition,
            notificationMetadata: props.notificationMetadata,
            notificationTargetArn: targetProps.notificationTargetArn,
            roleArn: this.role.roleArn,
        });
        // A LifecycleHook resource is going to do a permissions test upon creation,
        // so we have to make sure the role has full permissions before creating the
        // lifecycle hook.
        resource.node.addDependency(this.role);
        this.lifecycleHookName = resource.ref;
    }
}
exports.LifecycleHook = LifecycleHook;
var DefaultResult;
(function (DefaultResult) {
    DefaultResult["CONTINUE"] = "CONTINUE";
    DefaultResult["ABANDON"] = "ABANDON";
})(DefaultResult = exports.DefaultResult || (exports.DefaultResult = {}));
/**
 * What instance transition to attach the hook to
 */
var LifecycleTransition;
(function (LifecycleTransition) {
    /**
     * Execute the hook when an instance is about to be added
     */
    LifecycleTransition["INSTANCE_LAUNCHING"] = "autoscaling:EC2_INSTANCE_LAUNCHING";
    /**
     * Execute the hook when an instance is about to be terminated
     */
    LifecycleTransition["INSTANCE_TERMINATING"] = "autoscaling:EC2_INSTANCE_TERMINATING";
})(LifecycleTransition = exports.LifecycleTransition || (exports.LifecycleTransition = {}));
//# sourceMappingURL=data:application/json;base64,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