"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Use an SNS topic as a hook target
 */
class TopicHook {
    constructor(topic) {
        this.topic = topic;
    }
    bind(_scope, lifecycleHook) {
        this.topic.grantPublish(lifecycleHook.role);
        return { notificationTargetArn: this.topic.topicArn };
    }
}
exports.TopicHook = TopicHook;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidG9waWMtaG9vay5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInRvcGljLWhvb2sudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFHQTs7R0FFRztBQUNILE1BQWEsU0FBUztJQUNsQixZQUE2QixLQUFpQjtRQUFqQixVQUFLLEdBQUwsS0FBSyxDQUFZO0lBQzlDLENBQUM7SUFDTSxJQUFJLENBQUMsTUFBaUIsRUFBRSxhQUF5QztRQUNwRSxJQUFJLENBQUMsS0FBSyxDQUFDLFlBQVksQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDNUMsT0FBTyxFQUFFLHFCQUFxQixFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsUUFBUSxFQUFFLENBQUM7SUFDMUQsQ0FBQztDQUNKO0FBUEQsOEJBT0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBhdXRvc2NhbGluZyBmcm9tIFwiLi4vLi4vYXdzLWF1dG9zY2FsaW5nXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9hd3MtYXV0b3NjYWxpbmcnXG5pbXBvcnQgKiBhcyBzbnMgZnJvbSBcIi4uLy4uL2F3cy1zbnNcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2F3cy1zbnMnXG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tIFwiLi4vLi4vY29yZVwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvY29yZSdcbi8qKlxuICogVXNlIGFuIFNOUyB0b3BpYyBhcyBhIGhvb2sgdGFyZ2V0XG4gKi9cbmV4cG9ydCBjbGFzcyBUb3BpY0hvb2sgaW1wbGVtZW50cyBhdXRvc2NhbGluZy5JTGlmZWN5Y2xlSG9va1RhcmdldCB7XG4gICAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSB0b3BpYzogc25zLklUb3BpYykge1xuICAgIH1cbiAgICBwdWJsaWMgYmluZChfc2NvcGU6IENvbnN0cnVjdCwgbGlmZWN5Y2xlSG9vazogYXV0b3NjYWxpbmcuSUxpZmVjeWNsZUhvb2spOiBhdXRvc2NhbGluZy5MaWZlY3ljbGVIb29rVGFyZ2V0Q29uZmlnIHtcbiAgICAgICAgdGhpcy50b3BpYy5ncmFudFB1Ymxpc2gobGlmZWN5Y2xlSG9vay5yb2xlKTtcbiAgICAgICAgcmV0dXJuIHsgbm90aWZpY2F0aW9uVGFyZ2V0QXJuOiB0aGlzLnRvcGljLnRvcGljQXJuIH07XG4gICAgfVxufVxuIl19