"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Use an SQS queue as a hook target
 */
class QueueHook {
    constructor(queue) {
        this.queue = queue;
    }
    bind(_scope, lifecycleHook) {
        this.queue.grantSendMessages(lifecycleHook.role);
        return { notificationTargetArn: this.queue.queueArn };
    }
}
exports.QueueHook = QueueHook;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicXVldWUtaG9vay5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInF1ZXVlLWhvb2sudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFHQTs7R0FFRztBQUNILE1BQWEsU0FBUztJQUNsQixZQUE2QixLQUFpQjtRQUFqQixVQUFLLEdBQUwsS0FBSyxDQUFZO0lBQzlDLENBQUM7SUFDTSxJQUFJLENBQUMsTUFBaUIsRUFBRSxhQUF5QztRQUNwRSxJQUFJLENBQUMsS0FBSyxDQUFDLGlCQUFpQixDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUNqRCxPQUFPLEVBQUUscUJBQXFCLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxRQUFRLEVBQUUsQ0FBQztJQUMxRCxDQUFDO0NBQ0o7QUFQRCw4QkFPQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGF1dG9zY2FsaW5nIGZyb20gXCIuLi8uLi9hd3MtYXV0b3NjYWxpbmdcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2F3cy1hdXRvc2NhbGluZydcbmltcG9ydCAqIGFzIHNxcyBmcm9tIFwiLi4vLi4vYXdzLXNxc1wiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvYXdzLXNxcydcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gXCIuLi8uLi9jb3JlXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9jb3JlJ1xuLyoqXG4gKiBVc2UgYW4gU1FTIHF1ZXVlIGFzIGEgaG9vayB0YXJnZXRcbiAqL1xuZXhwb3J0IGNsYXNzIFF1ZXVlSG9vayBpbXBsZW1lbnRzIGF1dG9zY2FsaW5nLklMaWZlY3ljbGVIb29rVGFyZ2V0IHtcbiAgICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IHF1ZXVlOiBzcXMuSVF1ZXVlKSB7XG4gICAgfVxuICAgIHB1YmxpYyBiaW5kKF9zY29wZTogQ29uc3RydWN0LCBsaWZlY3ljbGVIb29rOiBhdXRvc2NhbGluZy5JTGlmZWN5Y2xlSG9vayk6IGF1dG9zY2FsaW5nLkxpZmVjeWNsZUhvb2tUYXJnZXRDb25maWcge1xuICAgICAgICB0aGlzLnF1ZXVlLmdyYW50U2VuZE1lc3NhZ2VzKGxpZmVjeWNsZUhvb2sucm9sZSk7XG4gICAgICAgIHJldHVybiB7IG5vdGlmaWNhdGlvblRhcmdldEFybjogdGhpcy5xdWV1ZS5xdWV1ZUFybiB9O1xuICAgIH1cbn1cbiJdfQ==