"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const apigatewayv2_generated_1 = require("../apigatewayv2.generated");
const integration_1 = require("./integration");
/**
 * Supported HTTP methods
 */
var HttpMethod;
(function (HttpMethod) {
    /** HTTP ANY */
    HttpMethod["ANY"] = "ANY";
    /** HTTP DELETE */
    HttpMethod["DELETE"] = "DELETE";
    /** HTTP GET */
    HttpMethod["GET"] = "GET";
    /** HTTP HEAD */
    HttpMethod["HEAD"] = "HEAD";
    /** HTTP OPTIONS */
    HttpMethod["OPTIONS"] = "OPTIONS";
    /** HTTP PATCH */
    HttpMethod["PATCH"] = "PATCH";
    /** HTTP POST */
    HttpMethod["POST"] = "POST";
    /** HTTP PUT */
    HttpMethod["PUT"] = "PUT";
})(HttpMethod = exports.HttpMethod || (exports.HttpMethod = {}));
/**
 * HTTP route in APIGateway is a combination of the HTTP method and the path component.
 * This class models that combination.
 */
class HttpRouteKey {
    constructor(key, path) {
        this.key = key;
        this.path = path;
    }
    /**
     * Create a route key with the combination of the path and the method.
     * @param method default is 'ANY'
     */
    static with(path, method) {
        if (path !== '/' && (!path.startsWith('/') || path.endsWith('/'))) {
            throw new Error('path must always start with a "/" and not end with a "/"');
        }
        return new HttpRouteKey(`${method !== null && method !== void 0 ? method : 'ANY'} ${path}`, path);
    }
}
exports.HttpRouteKey = HttpRouteKey;
/**
 * The catch-all route of the API, i.e., when no other routes match
 */
HttpRouteKey.DEFAULT = new HttpRouteKey('$default');
/**
 * Route class that creates the Route for API Gateway HTTP API
 * @resource AWS::ApiGatewayV2::Route
 */
class HttpRoute extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        this.httpApi = props.httpApi;
        this.path = props.routeKey.path;
        let integration;
        const config = props.integration.bind(this);
        integration = new integration_1.HttpIntegration(this, `${this.node.id}-Integration`, {
            httpApi: props.httpApi,
            integrationType: config.type,
            integrationUri: config.uri,
            method: config.method,
            payloadFormatVersion: config.payloadFormatVersion,
        });
        const routeProps = {
            apiId: props.httpApi.httpApiId,
            routeKey: props.routeKey.key,
            target: `integrations/${integration.integrationId}`,
        };
        const route = new apigatewayv2_generated_1.CfnRoute(this, 'Resource', routeProps);
        this.routeId = route.ref;
    }
}
exports.HttpRoute = HttpRoute;
//# sourceMappingURL=data:application/json;base64,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