"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const apigatewayv2_generated_1 = require("../apigatewayv2.generated");
const route_1 = require("./route");
const stage_1 = require("./stage");
/**
 * Create a new API Gateway HTTP API endpoint.
 * @resource AWS::ApiGatewayV2::Api
 */
class HttpApi extends core_1.Resource {
    constructor(scope, id, props) {
        var _a;
        super(scope, id);
        const apiName = (_a = props === null || props === void 0 ? void 0 : props.apiName) !== null && _a !== void 0 ? _a : id;
        let corsConfiguration;
        if (props === null || props === void 0 ? void 0 : props.corsPreflight) {
            const { allowCredentials, allowHeaders, allowMethods, allowOrigins, exposeHeaders, maxAge, } = props.corsPreflight;
            corsConfiguration = {
                allowCredentials,
                allowHeaders,
                allowMethods,
                allowOrigins,
                exposeHeaders,
                maxAge: maxAge === null || maxAge === void 0 ? void 0 : maxAge.toSeconds(),
            };
        }
        const apiProps = {
            name: apiName,
            protocolType: 'HTTP',
            corsConfiguration,
        };
        const resource = new apigatewayv2_generated_1.CfnApi(this, 'Resource', apiProps);
        this.httpApiId = resource.ref;
        if (props === null || props === void 0 ? void 0 : props.defaultIntegration) {
            new route_1.HttpRoute(this, 'DefaultRoute', {
                httpApi: this,
                routeKey: route_1.HttpRouteKey.DEFAULT,
                integration: props.defaultIntegration,
            });
        }
        if ((props === null || props === void 0 ? void 0 : props.createDefaultStage) === undefined || props.createDefaultStage === true) {
            this.defaultStage = new stage_1.HttpStage(this, 'DefaultStage', {
                httpApi: this,
                autoDeploy: true,
            });
        }
    }
    /**
     * Import an existing HTTP API into this CDK app.
     */
    static fromApiId(scope, id, httpApiId) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.httpApiId = httpApiId;
            }
        }
        return new Import(scope, id);
    }
    /**
     * Get the URL to the default stage of this API.
     * Returns `undefined` if `createDefaultStage` is unset.
     */
    get url() {
        return this.defaultStage ? this.defaultStage.url : undefined;
    }
    /**
     * Add a new stage.
     */
    addStage(id, options) {
        return new stage_1.HttpStage(this, id, {
            httpApi: this,
            ...options,
        });
    }
    /**
     * Add multiple routes that uses the same configuration. The routes all go to the same path, but for different
     * methods.
     */
    addRoutes(options) {
        var _a;
        const methods = (_a = options.methods) !== null && _a !== void 0 ? _a : [route_1.HttpMethod.ANY];
        return methods.map((method) => new route_1.HttpRoute(this, `${method}${options.path}`, {
            httpApi: this,
            routeKey: route_1.HttpRouteKey.with(options.path, method),
            integration: options.integration,
        }));
    }
}
exports.HttpApi = HttpApi;
//# sourceMappingURL=data:application/json;base64,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