"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const apigateway_generated_1 = require("./apigateway.generated");
const restapi_1 = require("./restapi");
const util = require("./util");
/**
 * Represents a reference to a REST API's Empty model, which is available
 * as part of the model collection by default. This can be used for mapping
 * JSON responses from an integration to what is returned to a client,
 * where strong typing is not required. In the absence of any defined
 * model, the Empty model will be used to return the response payload
 * unmapped.
 *
 * Definition
 * {
 *   "$schema" : "http://json-schema.org/draft-04/schema#",
 *   "title" : "Empty Schema",
 *   "type" : "object"
 * }
 *
 * @see https://docs.amazonaws.cn/en_us/apigateway/latest/developerguide/models-mappings.html#models-mappings-models
 * @deprecated You should use @see Model.EMPTY_MODEL
 */
class EmptyModel {
    constructor() {
        this.modelId = 'Empty';
    }
}
exports.EmptyModel = EmptyModel;
/**
 * Represents a reference to a REST API's Error model, which is available
 * as part of the model collection by default. This can be used for mapping
 * error JSON responses from an integration to a client, where a simple
 * generic message field is sufficient to map and return an error payload.
 *
 * Definition
 * {
 *   "$schema" : "http://json-schema.org/draft-04/schema#",
 *   "title" : "Error Schema",
 *   "type" : "object",
 *   "properties" : {
 *     "message" : { "type" : "string" }
 *   }
 * }
 * @deprecated You should use @see Model.ERROR_MODEL
 */
class ErrorModel {
    constructor() {
        this.modelId = 'Error';
    }
}
exports.ErrorModel = ErrorModel;
class Model extends core_1.Resource {
    constructor(scope, id, props) {
        var _a;
        super(scope, id, {
            physicalName: props.modelName,
        });
        const modelProps = {
            name: this.physicalName,
            restApiId: props.restApi.restApiId,
            contentType: (_a = props.contentType) !== null && _a !== void 0 ? _a : 'application/json',
            description: props.description,
            schema: util.JsonSchemaMapper.toCfnJsonSchema(props.schema),
        };
        const resource = new apigateway_generated_1.CfnModel(this, 'Resource', modelProps);
        this.modelId = this.getResourceNameAttribute(resource.ref);
        const deployment = (props.restApi instanceof restapi_1.RestApi) ? props.restApi.latestDeployment : undefined;
        if (deployment) {
            deployment.node.addDependency(resource);
            deployment.addToLogicalId({ model: modelProps });
        }
    }
    static fromModelName(scope, id, modelName) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.modelId = modelName;
            }
        }
        return new Import(scope, id);
    }
}
exports.Model = Model;
/**
 * Represents a reference to a REST API's Error model, which is available
 * as part of the model collection by default. This can be used for mapping
 * error JSON responses from an integration to a client, where a simple
 * generic message field is sufficient to map and return an error payload.
 *
 * Definition
 * {
 *   "$schema" : "http://json-schema.org/draft-04/schema#",
 *   "title" : "Error Schema",
 *   "type" : "object",
 *   "properties" : {
 *     "message" : { "type" : "string" }
 *   }
 * }
 */
Model.ERROR_MODEL = new ErrorModel();
/**
 * Represents a reference to a REST API's Empty model, which is available
 * as part of the model collection by default. This can be used for mapping
 * JSON responses from an integration to what is returned to a client,
 * where strong typing is not required. In the absence of any defined
 * model, the Empty model will be used to return the response payload
 * unmapped.
 *
 * Definition
 * {
 *   "$schema" : "http://json-schema.org/draft-04/schema#",
 *   "title" : "Empty Schema",
 *   "type" : "object"
 * }
 *
 * @see https://docs.amazonaws.cn/en_us/apigateway/latest/developerguide/models-mappings.html#models-mappings-models
 */
Model.EMPTY_MODEL = new EmptyModel();
//# sourceMappingURL=data:application/json;base64,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