"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const integration_1 = require("../integration");
/**
 * This type of integration lets API Gateway return a response without sending
 * the request further to the backend. This is useful for API testing because it
 * can be used to test the integration set up without incurring charges for
 * using the backend and to enable collaborative development of an API. In
 * collaborative development, a team can isolate their development effort by
 * setting up simulations of API components owned by other teams by using the
 * MOCK integrations. It is also used to return CORS-related headers to ensure
 * that the API method permits CORS access. In fact, the API Gateway console
 * integrates the OPTIONS method to support CORS with a mock integration.
 * Gateway responses are other examples of mock integrations.
 */
class MockIntegration extends integration_1.Integration {
    constructor(options) {
        super({
            type: integration_1.IntegrationType.MOCK,
            options,
        });
    }
}
exports.MockIntegration = MockIntegration;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibW9jay5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIm1vY2sudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxnREFBa0Y7QUFDbEY7Ozs7Ozs7Ozs7O0dBV0c7QUFDSCxNQUFhLGVBQWdCLFNBQVEseUJBQVc7SUFDNUMsWUFBWSxPQUE0QjtRQUNwQyxLQUFLLENBQUM7WUFDRixJQUFJLEVBQUUsNkJBQWUsQ0FBQyxJQUFJO1lBQzFCLE9BQU87U0FDVixDQUFDLENBQUM7SUFDUCxDQUFDO0NBQ0o7QUFQRCwwQ0FPQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEludGVncmF0aW9uLCBJbnRlZ3JhdGlvbk9wdGlvbnMsIEludGVncmF0aW9uVHlwZSB9IGZyb20gJy4uL2ludGVncmF0aW9uJztcbi8qKlxuICogVGhpcyB0eXBlIG9mIGludGVncmF0aW9uIGxldHMgQVBJIEdhdGV3YXkgcmV0dXJuIGEgcmVzcG9uc2Ugd2l0aG91dCBzZW5kaW5nXG4gKiB0aGUgcmVxdWVzdCBmdXJ0aGVyIHRvIHRoZSBiYWNrZW5kLiBUaGlzIGlzIHVzZWZ1bCBmb3IgQVBJIHRlc3RpbmcgYmVjYXVzZSBpdFxuICogY2FuIGJlIHVzZWQgdG8gdGVzdCB0aGUgaW50ZWdyYXRpb24gc2V0IHVwIHdpdGhvdXQgaW5jdXJyaW5nIGNoYXJnZXMgZm9yXG4gKiB1c2luZyB0aGUgYmFja2VuZCBhbmQgdG8gZW5hYmxlIGNvbGxhYm9yYXRpdmUgZGV2ZWxvcG1lbnQgb2YgYW4gQVBJLiBJblxuICogY29sbGFib3JhdGl2ZSBkZXZlbG9wbWVudCwgYSB0ZWFtIGNhbiBpc29sYXRlIHRoZWlyIGRldmVsb3BtZW50IGVmZm9ydCBieVxuICogc2V0dGluZyB1cCBzaW11bGF0aW9ucyBvZiBBUEkgY29tcG9uZW50cyBvd25lZCBieSBvdGhlciB0ZWFtcyBieSB1c2luZyB0aGVcbiAqIE1PQ0sgaW50ZWdyYXRpb25zLiBJdCBpcyBhbHNvIHVzZWQgdG8gcmV0dXJuIENPUlMtcmVsYXRlZCBoZWFkZXJzIHRvIGVuc3VyZVxuICogdGhhdCB0aGUgQVBJIG1ldGhvZCBwZXJtaXRzIENPUlMgYWNjZXNzLiBJbiBmYWN0LCB0aGUgQVBJIEdhdGV3YXkgY29uc29sZVxuICogaW50ZWdyYXRlcyB0aGUgT1BUSU9OUyBtZXRob2QgdG8gc3VwcG9ydCBDT1JTIHdpdGggYSBtb2NrIGludGVncmF0aW9uLlxuICogR2F0ZXdheSByZXNwb25zZXMgYXJlIG90aGVyIGV4YW1wbGVzIG9mIG1vY2sgaW50ZWdyYXRpb25zLlxuICovXG5leHBvcnQgY2xhc3MgTW9ja0ludGVncmF0aW9uIGV4dGVuZHMgSW50ZWdyYXRpb24ge1xuICAgIGNvbnN0cnVjdG9yKG9wdGlvbnM/OiBJbnRlZ3JhdGlvbk9wdGlvbnMpIHtcbiAgICAgICAgc3VwZXIoe1xuICAgICAgICAgICAgdHlwZTogSW50ZWdyYXRpb25UeXBlLk1PQ0ssXG4gICAgICAgICAgICBvcHRpb25zLFxuICAgICAgICB9KTtcbiAgICB9XG59XG4iXX0=