"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const integration_1 = require("../integration");
const util_1 = require("../util");
/**
 * This type of integration lets an API expose AWS service actions. It is
 * intended for calling all AWS service actions, but is not recommended for
 * calling a Lambda function, because the Lambda custom integration is a legacy
 * technology.
 */
class AwsIntegration extends integration_1.Integration {
    constructor(props) {
        const backend = props.subdomain ? `${props.subdomain}.${props.service}` : props.service;
        const type = props.proxy ? integration_1.IntegrationType.AWS_PROXY : integration_1.IntegrationType.AWS;
        const { apiType, apiValue } = util_1.parseAwsApiCall(props.path, props.action, props.actionParameters);
        super({
            type,
            integrationHttpMethod: props.integrationHttpMethod || 'POST',
            uri: cdk.Lazy.stringValue({ produce: () => {
                    if (!this.scope) {
                        throw new Error('AwsIntegration must be used in API');
                    }
                    return cdk.Stack.of(this.scope).formatArn({
                        service: 'apigateway',
                        account: backend,
                        resource: apiType,
                        sep: '/',
                        resourceName: apiValue,
                    });
                } }),
            options: props.options,
        });
    }
    bind(method) {
        this.scope = method;
    }
}
exports.AwsIntegration = AwsIntegration;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXdzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiYXdzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEscUNBQXFDLENBQUMsZ0RBQWdEO0FBQ3RGLGdEQUFrRjtBQUVsRixrQ0FBMEM7QUFzRDFDOzs7OztHQUtHO0FBQ0gsTUFBYSxjQUFlLFNBQVEseUJBQVc7SUFFM0MsWUFBWSxLQUEwQjtRQUNsQyxNQUFNLE9BQU8sR0FBRyxLQUFLLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQyxHQUFHLEtBQUssQ0FBQyxTQUFTLElBQUksS0FBSyxDQUFDLE9BQU8sRUFBRSxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDO1FBQ3hGLE1BQU0sSUFBSSxHQUFHLEtBQUssQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLDZCQUFlLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQyw2QkFBZSxDQUFDLEdBQUcsQ0FBQztRQUMzRSxNQUFNLEVBQUUsT0FBTyxFQUFFLFFBQVEsRUFBRSxHQUFHLHNCQUFlLENBQUMsS0FBSyxDQUFDLElBQUksRUFBRSxLQUFLLENBQUMsTUFBTSxFQUFFLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO1FBQ2hHLEtBQUssQ0FBQztZQUNGLElBQUk7WUFDSixxQkFBcUIsRUFBRSxLQUFLLENBQUMscUJBQXFCLElBQUksTUFBTTtZQUM1RCxHQUFHLEVBQUUsR0FBRyxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsRUFBRSxPQUFPLEVBQUUsR0FBRyxFQUFFO29CQUNsQyxJQUFJLENBQUMsSUFBSSxDQUFDLEtBQUssRUFBRTt3QkFDYixNQUFNLElBQUksS0FBSyxDQUFDLG9DQUFvQyxDQUFDLENBQUM7cUJBQ3pEO29CQUNELE9BQU8sR0FBRyxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLFNBQVMsQ0FBQzt3QkFDdEMsT0FBTyxFQUFFLFlBQVk7d0JBQ3JCLE9BQU8sRUFBRSxPQUFPO3dCQUNoQixRQUFRLEVBQUUsT0FBTzt3QkFDakIsR0FBRyxFQUFFLEdBQUc7d0JBQ1IsWUFBWSxFQUFFLFFBQVE7cUJBQ3pCLENBQUMsQ0FBQztnQkFDUCxDQUFDLEVBQUUsQ0FBQztZQUNSLE9BQU8sRUFBRSxLQUFLLENBQUMsT0FBTztTQUN6QixDQUFDLENBQUM7SUFDUCxDQUFDO0lBQ00sSUFBSSxDQUFDLE1BQWM7UUFDdEIsSUFBSSxDQUFDLEtBQUssR0FBRyxNQUFNLENBQUM7SUFDeEIsQ0FBQztDQUNKO0FBM0JELHdDQTJCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNkayBmcm9tIFwiLi4vLi4vLi4vY29yZVwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvY29yZSdcbmltcG9ydCB7IEludGVncmF0aW9uLCBJbnRlZ3JhdGlvbk9wdGlvbnMsIEludGVncmF0aW9uVHlwZSB9IGZyb20gJy4uL2ludGVncmF0aW9uJztcbmltcG9ydCB7IE1ldGhvZCB9IGZyb20gJy4uL21ldGhvZCc7XG5pbXBvcnQgeyBwYXJzZUF3c0FwaUNhbGwgfSBmcm9tICcuLi91dGlsJztcbmV4cG9ydCBpbnRlcmZhY2UgQXdzSW50ZWdyYXRpb25Qcm9wcyB7XG4gICAgLyoqXG4gICAgICogVXNlIEFXU19QUk9YWSBpbnRlZ3JhdGlvbi5cbiAgICAgKlxuICAgICAqIEBkZWZhdWx0IGZhbHNlXG4gICAgICovXG4gICAgcmVhZG9ubHkgcHJveHk/OiBib29sZWFuO1xuICAgIC8qKlxuICAgICAqIFRoZSBuYW1lIG9mIHRoZSBpbnRlZ3JhdGVkIEFXUyBzZXJ2aWNlIChlLmcuIGBzM2ApXG4gICAgICovXG4gICAgcmVhZG9ubHkgc2VydmljZTogc3RyaW5nO1xuICAgIC8qKlxuICAgICAqIEEgZGVzaWduYXRlZCBzdWJkb21haW4gc3VwcG9ydGVkIGJ5IGNlcnRhaW4gQVdTIHNlcnZpY2UgZm9yIGZhc3RcbiAgICAgKiBob3N0LW5hbWUgbG9va3VwLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHN1YmRvbWFpbj86IHN0cmluZztcbiAgICAvKipcbiAgICAgKiBUaGUgcGF0aCB0byB1c2UgZm9yIHBhdGgtYmFzZSBBUElzLlxuICAgICAqXG4gICAgICogRm9yIGV4YW1wbGUsIGZvciBTMyBHRVQsIHlvdSBjYW4gc2V0IHBhdGggdG8gYGJ1Y2tldC9rZXlgLlxuICAgICAqIEZvciBsYW1iZGEsIHlvdSBjYW4gc2V0IHBhdGggdG8gYDIwMTUtMDMtMzEvZnVuY3Rpb25zLyR7ZnVuY3Rpb24tYXJufS9pbnZvY2F0aW9uc2BcbiAgICAgKlxuICAgICAqIE11dHVhbGx5IGV4Y2x1c2l2ZSB3aXRoIHRoZSBgYWN0aW9uYCBvcHRpb25zLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHBhdGg/OiBzdHJpbmc7XG4gICAgLyoqXG4gICAgICogVGhlIEFXUyBhY3Rpb24gdG8gcGVyZm9ybSBpbiB0aGUgaW50ZWdyYXRpb24uXG4gICAgICpcbiAgICAgKiBVc2UgYGFjdGlvblBhcmFtc2AgdG8gc3BlY2lmeSBrZXktdmFsdWUgcGFyYW1zIGZvciB0aGUgYWN0aW9uLlxuICAgICAqXG4gICAgICogTXV0dWFsbHkgZXhjbHVzaXZlIHdpdGggYHBhdGhgLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGFjdGlvbj86IHN0cmluZztcbiAgICAvKipcbiAgICAgKiBQYXJhbWV0ZXJzIGZvciB0aGUgYWN0aW9uLlxuICAgICAqXG4gICAgICogYGFjdGlvbmAgbXVzdCBiZSBzZXQsIGFuZCBgcGF0aGAgbXVzdCBiZSB1bmRlZmluZWQuXG4gICAgICogVGhlIGFjdGlvbiBwYXJhbXMgd2lsbCBiZSBVUkwgZW5jb2RlZC5cbiAgICAgKi9cbiAgICByZWFkb25seSBhY3Rpb25QYXJhbWV0ZXJzPzoge1xuICAgICAgICBba2V5OiBzdHJpbmddOiBzdHJpbmc7XG4gICAgfTtcbiAgICAvKipcbiAgICAgKiBUaGUgaW50ZWdyYXRpb24ncyBIVFRQIG1ldGhvZCB0eXBlLlxuICAgICAqXG4gICAgICogQGRlZmF1bHQgUE9TVFxuICAgICAqL1xuICAgIHJlYWRvbmx5IGludGVncmF0aW9uSHR0cE1ldGhvZD86IHN0cmluZztcbiAgICAvKipcbiAgICAgKiBJbnRlZ3JhdGlvbiBvcHRpb25zLCBzdWNoIGFzIGNvbnRlbnQgaGFuZGxpbmcsIHJlcXVlc3QvcmVzcG9uc2UgbWFwcGluZywgZXRjLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IG9wdGlvbnM/OiBJbnRlZ3JhdGlvbk9wdGlvbnM7XG59XG4vKipcbiAqIFRoaXMgdHlwZSBvZiBpbnRlZ3JhdGlvbiBsZXRzIGFuIEFQSSBleHBvc2UgQVdTIHNlcnZpY2UgYWN0aW9ucy4gSXQgaXNcbiAqIGludGVuZGVkIGZvciBjYWxsaW5nIGFsbCBBV1Mgc2VydmljZSBhY3Rpb25zLCBidXQgaXMgbm90IHJlY29tbWVuZGVkIGZvclxuICogY2FsbGluZyBhIExhbWJkYSBmdW5jdGlvbiwgYmVjYXVzZSB0aGUgTGFtYmRhIGN1c3RvbSBpbnRlZ3JhdGlvbiBpcyBhIGxlZ2FjeVxuICogdGVjaG5vbG9neS5cbiAqL1xuZXhwb3J0IGNsYXNzIEF3c0ludGVncmF0aW9uIGV4dGVuZHMgSW50ZWdyYXRpb24ge1xuICAgIHByaXZhdGUgc2NvcGU/OiBjZGsuSUNvbnN0cnVjdDtcbiAgICBjb25zdHJ1Y3Rvcihwcm9wczogQXdzSW50ZWdyYXRpb25Qcm9wcykge1xuICAgICAgICBjb25zdCBiYWNrZW5kID0gcHJvcHMuc3ViZG9tYWluID8gYCR7cHJvcHMuc3ViZG9tYWlufS4ke3Byb3BzLnNlcnZpY2V9YCA6IHByb3BzLnNlcnZpY2U7XG4gICAgICAgIGNvbnN0IHR5cGUgPSBwcm9wcy5wcm94eSA/IEludGVncmF0aW9uVHlwZS5BV1NfUFJPWFkgOiBJbnRlZ3JhdGlvblR5cGUuQVdTO1xuICAgICAgICBjb25zdCB7IGFwaVR5cGUsIGFwaVZhbHVlIH0gPSBwYXJzZUF3c0FwaUNhbGwocHJvcHMucGF0aCwgcHJvcHMuYWN0aW9uLCBwcm9wcy5hY3Rpb25QYXJhbWV0ZXJzKTtcbiAgICAgICAgc3VwZXIoe1xuICAgICAgICAgICAgdHlwZSxcbiAgICAgICAgICAgIGludGVncmF0aW9uSHR0cE1ldGhvZDogcHJvcHMuaW50ZWdyYXRpb25IdHRwTWV0aG9kIHx8ICdQT1NUJyxcbiAgICAgICAgICAgIHVyaTogY2RrLkxhenkuc3RyaW5nVmFsdWUoeyBwcm9kdWNlOiAoKSA9PiB7XG4gICAgICAgICAgICAgICAgICAgIGlmICghdGhpcy5zY29wZSkge1xuICAgICAgICAgICAgICAgICAgICAgICAgdGhyb3cgbmV3IEVycm9yKCdBd3NJbnRlZ3JhdGlvbiBtdXN0IGJlIHVzZWQgaW4gQVBJJyk7XG4gICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgcmV0dXJuIGNkay5TdGFjay5vZih0aGlzLnNjb3BlKS5mb3JtYXRBcm4oe1xuICAgICAgICAgICAgICAgICAgICAgICAgc2VydmljZTogJ2FwaWdhdGV3YXknLFxuICAgICAgICAgICAgICAgICAgICAgICAgYWNjb3VudDogYmFja2VuZCxcbiAgICAgICAgICAgICAgICAgICAgICAgIHJlc291cmNlOiBhcGlUeXBlLFxuICAgICAgICAgICAgICAgICAgICAgICAgc2VwOiAnLycsXG4gICAgICAgICAgICAgICAgICAgICAgICByZXNvdXJjZU5hbWU6IGFwaVZhbHVlLFxuICAgICAgICAgICAgICAgICAgICB9KTtcbiAgICAgICAgICAgICAgICB9IH0pLFxuICAgICAgICAgICAgb3B0aW9uczogcHJvcHMub3B0aW9ucyxcbiAgICAgICAgfSk7XG4gICAgfVxuICAgIHB1YmxpYyBiaW5kKG1ldGhvZDogTWV0aG9kKSB7XG4gICAgICAgIHRoaXMuc2NvcGUgPSBtZXRob2Q7XG4gICAgfVxufVxuIl19