"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const apigateway_generated_1 = require("./apigateway.generated");
const base_path_mapping_1 = require("./base-path-mapping");
const restapi_1 = require("./restapi");
/**
 * The minimum version of the SSL protocol that you want API Gateway to use for HTTPS connections.
 */
var SecurityPolicy;
(function (SecurityPolicy) {
    /** Cipher suite TLS 1.0 */
    SecurityPolicy["TLS_1_0"] = "TLS_1_0";
    /** Cipher suite TLS 1.2 */
    SecurityPolicy["TLS_1_2"] = "TLS_1_2";
})(SecurityPolicy = exports.SecurityPolicy || (exports.SecurityPolicy = {}));
class DomainName extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        const endpointType = props.endpointType || restapi_1.EndpointType.REGIONAL;
        const edge = endpointType === restapi_1.EndpointType.EDGE;
        const resource = new apigateway_generated_1.CfnDomainName(this, 'Resource', {
            domainName: props.domainName,
            certificateArn: edge ? props.certificate.certificateArn : undefined,
            regionalCertificateArn: edge ? undefined : props.certificate.certificateArn,
            endpointConfiguration: { types: [endpointType] },
            securityPolicy: props.securityPolicy,
        });
        this.domainName = resource.ref;
        this.domainNameAliasDomainName = edge
            ? resource.attrDistributionDomainName
            : resource.attrRegionalDomainName;
        this.domainNameAliasHostedZoneId = edge
            ? resource.attrDistributionHostedZoneId
            : resource.attrRegionalHostedZoneId;
        if (props.mapping) {
            this.addBasePathMapping(props.mapping);
        }
    }
    /**
     * Imports an existing domain name.
     */
    static fromDomainNameAttributes(scope, id, attrs) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.domainName = attrs.domainName;
                this.domainNameAliasDomainName = attrs.domainNameAliasTarget;
                this.domainNameAliasHostedZoneId = attrs.domainNameAliasHostedZoneId;
            }
        }
        return new Import(scope, id);
    }
    /**
     * Maps this domain to an API endpoint.
     * @param targetApi That target API endpoint, requests will be mapped to the deployment stage.
     * @param options Options for mapping to base path with or without a stage
     */
    addBasePathMapping(targetApi, options = {}) {
        const basePath = options.basePath || '/';
        const id = `Map:${basePath}=>${targetApi.node.uniqueId}`;
        return new base_path_mapping_1.BasePathMapping(this, id, {
            domainName: this,
            restApi: targetApi,
            ...options,
        });
    }
}
exports.DomainName = DomainName;
//# sourceMappingURL=data:application/json;base64,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