"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// Copyright 2012-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Originally generated from the AWS CloudFormation Resource Specification. Now, hand managed.
// tslint:disable:max-line-length
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * Determine whether the given properties match those of a `CfnApiV2Props`
 *
 * @param properties - the TypeScript properties of a `CfnApiV2Props`
 *
 * @returns the result of the validation.
 */
function CfnApiV2PropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('apiKeySelectionExpression', cdk.validateString)(properties.apiKeySelectionExpression));
    errors.collect(cdk.propertyValidator('basePath', cdk.validateString)(properties.basePath));
    errors.collect(cdk.propertyValidator('body', cdk.validateObject)(properties.body));
    errors.collect(cdk.propertyValidator('bodyS3Location', CfnApiV2_BodyS3LocationPropertyValidator)(properties.bodyS3Location));
    errors.collect(cdk.propertyValidator('corsConfiguration', CfnApiV2_CorsPropertyValidator)(properties.corsConfiguration));
    errors.collect(cdk.propertyValidator('credentialsArn', cdk.validateString)(properties.credentialsArn));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('disableSchemaValidation', cdk.validateBoolean)(properties.disableSchemaValidation));
    errors.collect(cdk.propertyValidator('failOnWarnings', cdk.validateBoolean)(properties.failOnWarnings));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('protocolType', cdk.validateString)(properties.protocolType));
    errors.collect(cdk.propertyValidator('routeKey', cdk.validateString)(properties.routeKey));
    errors.collect(cdk.propertyValidator('routeSelectionExpression', cdk.validateString)(properties.routeSelectionExpression));
    errors.collect(cdk.propertyValidator('tags', cdk.validateObject)(properties.tags));
    errors.collect(cdk.propertyValidator('target', cdk.validateString)(properties.target));
    errors.collect(cdk.propertyValidator('version', cdk.validateString)(properties.version));
    return errors.wrap('supplied properties not correct for "CfnApiV2Props"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Api` resource
 *
 * @param properties - the TypeScript properties of a `CfnApiV2Props`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Api` resource.
 */
// @ts-ignore TS6133
function cfnApiV2PropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnApiV2PropsValidator(properties).assertSuccess();
    return {
        ApiKeySelectionExpression: cdk.stringToCloudFormation(properties.apiKeySelectionExpression),
        BasePath: cdk.stringToCloudFormation(properties.basePath),
        Body: cdk.objectToCloudFormation(properties.body),
        BodyS3Location: cfnApiV2BodyS3LocationPropertyToCloudFormation(properties.bodyS3Location),
        CorsConfiguration: cfnApiV2CorsPropertyToCloudFormation(properties.corsConfiguration),
        CredentialsArn: cdk.stringToCloudFormation(properties.credentialsArn),
        Description: cdk.stringToCloudFormation(properties.description),
        DisableSchemaValidation: cdk.booleanToCloudFormation(properties.disableSchemaValidation),
        FailOnWarnings: cdk.booleanToCloudFormation(properties.failOnWarnings),
        Name: cdk.stringToCloudFormation(properties.name),
        ProtocolType: cdk.stringToCloudFormation(properties.protocolType),
        RouteKey: cdk.stringToCloudFormation(properties.routeKey),
        RouteSelectionExpression: cdk.stringToCloudFormation(properties.routeSelectionExpression),
        Tags: cdk.objectToCloudFormation(properties.tags),
        Target: cdk.stringToCloudFormation(properties.target),
        Version: cdk.stringToCloudFormation(properties.version),
    };
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::Api`
 *
 * @cloudformationResource AWS::ApiGatewayV2::Api
 * @stability deprecated
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html
 * @deprecated moved to package aws-apigatewayv2
 */
class CfnApiV2 extends cdk.CfnResource {
    /**
     * Create a new `AWS::ApiGatewayV2::Api`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnApiV2.CFN_RESOURCE_TYPE_NAME, properties: props });
        this.apiKeySelectionExpression = props.apiKeySelectionExpression;
        this.basePath = props.basePath;
        this.body = props.body;
        this.bodyS3Location = props.bodyS3Location;
        this.corsConfiguration = props.corsConfiguration;
        this.credentialsArn = props.credentialsArn;
        this.description = props.description;
        this.disableSchemaValidation = props.disableSchemaValidation;
        this.failOnWarnings = props.failOnWarnings;
        this.name = props.name;
        this.protocolType = props.protocolType;
        this.routeKey = props.routeKey;
        this.routeSelectionExpression = props.routeSelectionExpression;
        this.tags = new cdk.TagManager(cdk.TagType.MAP, 'AWS::ApiGatewayV2::Api', props.tags, { tagPropertyName: 'tags' });
        this.target = props.target;
        this.version = props.version;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute('aws:cdk:cloudformation:type', CfnApiV2.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute('aws:cdk:cloudformation:props', this.cfnProperties);
    }
    get cfnProperties() {
        return {
            apiKeySelectionExpression: this.apiKeySelectionExpression,
            basePath: this.basePath,
            body: this.body,
            bodyS3Location: this.bodyS3Location,
            corsConfiguration: this.corsConfiguration,
            credentialsArn: this.credentialsArn,
            description: this.description,
            disableSchemaValidation: this.disableSchemaValidation,
            failOnWarnings: this.failOnWarnings,
            name: this.name,
            protocolType: this.protocolType,
            routeKey: this.routeKey,
            routeSelectionExpression: this.routeSelectionExpression,
            tags: this.tags.renderTags(),
            target: this.target,
            version: this.version,
        };
    }
    renderProperties(props) {
        return cfnApiV2PropsToCloudFormation(props);
    }
}
exports.CfnApiV2 = CfnApiV2;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnApiV2.CFN_RESOURCE_TYPE_NAME = 'AWS::ApiGatewayV2::Api';
/**
 * Determine whether the given properties match those of a `BodyS3LocationProperty`
 *
 * @param properties - the TypeScript properties of a `BodyS3LocationProperty`
 *
 * @returns the result of the validation.
 */
function CfnApiV2_BodyS3LocationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('bucket', cdk.validateString)(properties.bucket));
    errors.collect(cdk.propertyValidator('etag', cdk.validateString)(properties.etag));
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('version', cdk.validateString)(properties.version));
    return errors.wrap('supplied properties not correct for "BodyS3LocationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Api.BodyS3Location` resource
 *
 * @param properties - the TypeScript properties of a `BodyS3LocationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Api.BodyS3Location` resource.
 */
// @ts-ignore TS6133
function cfnApiV2BodyS3LocationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnApiV2_BodyS3LocationPropertyValidator(properties).assertSuccess();
    return {
        Bucket: cdk.stringToCloudFormation(properties.bucket),
        Etag: cdk.stringToCloudFormation(properties.etag),
        Key: cdk.stringToCloudFormation(properties.key),
        Version: cdk.stringToCloudFormation(properties.version),
    };
}
/**
 * Determine whether the given properties match those of a `CorsProperty`
 *
 * @param properties - the TypeScript properties of a `CorsProperty`
 *
 * @returns the result of the validation.
 */
function CfnApiV2_CorsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('allowCredentials', cdk.validateBoolean)(properties.allowCredentials));
    errors.collect(cdk.propertyValidator('allowHeaders', cdk.listValidator(cdk.validateString))(properties.allowHeaders));
    errors.collect(cdk.propertyValidator('allowMethods', cdk.listValidator(cdk.validateString))(properties.allowMethods));
    errors.collect(cdk.propertyValidator('allowOrigins', cdk.listValidator(cdk.validateString))(properties.allowOrigins));
    errors.collect(cdk.propertyValidator('exposeHeaders', cdk.listValidator(cdk.validateString))(properties.exposeHeaders));
    errors.collect(cdk.propertyValidator('maxAge', cdk.validateNumber)(properties.maxAge));
    return errors.wrap('supplied properties not correct for "CorsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Api.Cors` resource
 *
 * @param properties - the TypeScript properties of a `CorsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Api.Cors` resource.
 */
// @ts-ignore TS6133
function cfnApiV2CorsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnApiV2_CorsPropertyValidator(properties).assertSuccess();
    return {
        AllowCredentials: cdk.booleanToCloudFormation(properties.allowCredentials),
        AllowHeaders: cdk.listMapper(cdk.stringToCloudFormation)(properties.allowHeaders),
        AllowMethods: cdk.listMapper(cdk.stringToCloudFormation)(properties.allowMethods),
        AllowOrigins: cdk.listMapper(cdk.stringToCloudFormation)(properties.allowOrigins),
        ExposeHeaders: cdk.listMapper(cdk.stringToCloudFormation)(properties.exposeHeaders),
        MaxAge: cdk.numberToCloudFormation(properties.maxAge),
    };
}
/**
 * Determine whether the given properties match those of a `CfnApiMappingV2Props`
 *
 * @param properties - the TypeScript properties of a `CfnApiMappingV2Props`
 *
 * @returns the result of the validation.
 */
function CfnApiMappingV2PropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('apiId', cdk.requiredValidator)(properties.apiId));
    errors.collect(cdk.propertyValidator('apiId', cdk.validateString)(properties.apiId));
    errors.collect(cdk.propertyValidator('apiMappingKey', cdk.validateString)(properties.apiMappingKey));
    errors.collect(cdk.propertyValidator('domainName', cdk.requiredValidator)(properties.domainName));
    errors.collect(cdk.propertyValidator('domainName', cdk.validateString)(properties.domainName));
    errors.collect(cdk.propertyValidator('stage', cdk.requiredValidator)(properties.stage));
    errors.collect(cdk.propertyValidator('stage', cdk.validateString)(properties.stage));
    return errors.wrap('supplied properties not correct for "CfnApiMappingV2Props"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ApiGatewayV2::ApiMapping` resource
 *
 * @param properties - the TypeScript properties of a `CfnApiMappingV2Props`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ApiGatewayV2::ApiMapping` resource.
 */
// @ts-ignore TS6133
function cfnApiMappingV2PropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnApiMappingV2PropsValidator(properties).assertSuccess();
    return {
        ApiId: cdk.stringToCloudFormation(properties.apiId),
        DomainName: cdk.stringToCloudFormation(properties.domainName),
        Stage: cdk.stringToCloudFormation(properties.stage),
        ApiMappingKey: cdk.stringToCloudFormation(properties.apiMappingKey),
    };
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::ApiMapping`
 *
 * @cloudformationResource AWS::ApiGatewayV2::ApiMapping
 * @stability deprecated
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-apimapping.html
 * @deprecated moved to package aws-apigatewayv2
 */
class CfnApiMappingV2 extends cdk.CfnResource {
    /**
     * Create a new `AWS::ApiGatewayV2::ApiMapping`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnApiMappingV2.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'apiId', this);
        cdk.requireProperty(props, 'domainName', this);
        cdk.requireProperty(props, 'stage', this);
        this.apiId = props.apiId;
        this.domainName = props.domainName;
        this.stage = props.stage;
        this.apiMappingKey = props.apiMappingKey;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute('aws:cdk:cloudformation:type', CfnApiMappingV2.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute('aws:cdk:cloudformation:props', this.cfnProperties);
    }
    get cfnProperties() {
        return {
            apiId: this.apiId,
            domainName: this.domainName,
            stage: this.stage,
            apiMappingKey: this.apiMappingKey,
        };
    }
    renderProperties(props) {
        return cfnApiMappingV2PropsToCloudFormation(props);
    }
}
exports.CfnApiMappingV2 = CfnApiMappingV2;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnApiMappingV2.CFN_RESOURCE_TYPE_NAME = 'AWS::ApiGatewayV2::ApiMapping';
/**
 * Determine whether the given properties match those of a `CfnAuthorizerV2Props`
 *
 * @param properties - the TypeScript properties of a `CfnAuthorizerV2Props`
 *
 * @returns the result of the validation.
 */
function CfnAuthorizerV2PropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('apiId', cdk.requiredValidator)(properties.apiId));
    errors.collect(cdk.propertyValidator('apiId', cdk.validateString)(properties.apiId));
    errors.collect(cdk.propertyValidator('authorizerCredentialsArn', cdk.validateString)(properties.authorizerCredentialsArn));
    errors.collect(cdk.propertyValidator('authorizerResultTtlInSeconds', cdk.validateNumber)(properties.authorizerResultTtlInSeconds));
    errors.collect(cdk.propertyValidator('authorizerType', cdk.requiredValidator)(properties.authorizerType));
    errors.collect(cdk.propertyValidator('authorizerType', cdk.validateString)(properties.authorizerType));
    errors.collect(cdk.propertyValidator('authorizerUri', cdk.validateString)(properties.authorizerUri));
    errors.collect(cdk.propertyValidator('identitySource', cdk.requiredValidator)(properties.identitySource));
    errors.collect(cdk.propertyValidator('identitySource', cdk.listValidator(cdk.validateString))(properties.identitySource));
    errors.collect(cdk.propertyValidator('identityValidationExpression', cdk.validateString)(properties.identityValidationExpression));
    errors.collect(cdk.propertyValidator('jwtConfiguration', CfnAuthorizerV2_JWTConfigurationPropertyValidator)(properties.jwtConfiguration));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    return errors.wrap('supplied properties not correct for "CfnAuthorizerV2Props"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Authorizer` resource
 *
 * @param properties - the TypeScript properties of a `CfnAuthorizerV2Props`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Authorizer` resource.
 */
// @ts-ignore TS6133
function cfnAuthorizerV2PropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAuthorizerV2PropsValidator(properties).assertSuccess();
    return {
        ApiId: cdk.stringToCloudFormation(properties.apiId),
        AuthorizerType: cdk.stringToCloudFormation(properties.authorizerType),
        IdentitySource: cdk.listMapper(cdk.stringToCloudFormation)(properties.identitySource),
        Name: cdk.stringToCloudFormation(properties.name),
        AuthorizerCredentialsArn: cdk.stringToCloudFormation(properties.authorizerCredentialsArn),
        AuthorizerResultTtlInSeconds: cdk.numberToCloudFormation(properties.authorizerResultTtlInSeconds),
        AuthorizerUri: cdk.stringToCloudFormation(properties.authorizerUri),
        IdentityValidationExpression: cdk.stringToCloudFormation(properties.identityValidationExpression),
        JwtConfiguration: cfnAuthorizerV2JWTConfigurationPropertyToCloudFormation(properties.jwtConfiguration),
    };
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::Authorizer`
 *
 * @cloudformationResource AWS::ApiGatewayV2::Authorizer
 * @stability deprecated
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html
 * @deprecated moved to package aws-apigatewayv2
 */
class CfnAuthorizerV2 extends cdk.CfnResource {
    /**
     * Create a new `AWS::ApiGatewayV2::Authorizer`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnAuthorizerV2.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'apiId', this);
        cdk.requireProperty(props, 'authorizerType', this);
        cdk.requireProperty(props, 'identitySource', this);
        cdk.requireProperty(props, 'name', this);
        this.apiId = props.apiId;
        this.authorizerType = props.authorizerType;
        this.identitySource = props.identitySource;
        this.name = props.name;
        this.authorizerCredentialsArn = props.authorizerCredentialsArn;
        this.authorizerResultTtlInSeconds = props.authorizerResultTtlInSeconds;
        this.authorizerUri = props.authorizerUri;
        this.identityValidationExpression = props.identityValidationExpression;
        this.jwtConfiguration = props.jwtConfiguration;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute('aws:cdk:cloudformation:type', CfnAuthorizerV2.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute('aws:cdk:cloudformation:props', this.cfnProperties);
    }
    get cfnProperties() {
        return {
            apiId: this.apiId,
            authorizerType: this.authorizerType,
            identitySource: this.identitySource,
            name: this.name,
            authorizerCredentialsArn: this.authorizerCredentialsArn,
            authorizerResultTtlInSeconds: this.authorizerResultTtlInSeconds,
            authorizerUri: this.authorizerUri,
            identityValidationExpression: this.identityValidationExpression,
            jwtConfiguration: this.jwtConfiguration,
        };
    }
    renderProperties(props) {
        return cfnAuthorizerV2PropsToCloudFormation(props);
    }
}
exports.CfnAuthorizerV2 = CfnAuthorizerV2;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnAuthorizerV2.CFN_RESOURCE_TYPE_NAME = 'AWS::ApiGatewayV2::Authorizer';
/**
 * Determine whether the given properties match those of a `JWTConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `JWTConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAuthorizerV2_JWTConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('audience', cdk.listValidator(cdk.validateString))(properties.audience));
    errors.collect(cdk.propertyValidator('issuer', cdk.validateString)(properties.issuer));
    return errors.wrap('supplied properties not correct for "JWTConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Authorizer.JWTConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `JWTConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Authorizer.JWTConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAuthorizerV2JWTConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAuthorizerV2_JWTConfigurationPropertyValidator(properties).assertSuccess();
    return {
        Audience: cdk.listMapper(cdk.stringToCloudFormation)(properties.audience),
        Issuer: cdk.stringToCloudFormation(properties.issuer),
    };
}
/**
 * Determine whether the given properties match those of a `CfnDeploymentV2Props`
 *
 * @param properties - the TypeScript properties of a `CfnDeploymentV2Props`
 *
 * @returns the result of the validation.
 */
function CfnDeploymentV2PropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('apiId', cdk.requiredValidator)(properties.apiId));
    errors.collect(cdk.propertyValidator('apiId', cdk.validateString)(properties.apiId));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('stageName', cdk.validateString)(properties.stageName));
    return errors.wrap('supplied properties not correct for "CfnDeploymentV2Props"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Deployment` resource
 *
 * @param properties - the TypeScript properties of a `CfnDeploymentV2Props`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Deployment` resource.
 */
// @ts-ignore TS6133
function cfnDeploymentV2PropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDeploymentV2PropsValidator(properties).assertSuccess();
    return {
        ApiId: cdk.stringToCloudFormation(properties.apiId),
        Description: cdk.stringToCloudFormation(properties.description),
        StageName: cdk.stringToCloudFormation(properties.stageName),
    };
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::Deployment`
 *
 * @cloudformationResource AWS::ApiGatewayV2::Deployment
 * @stability deprecated
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-deployment.html
 * @deprecated moved to package aws-apigatewayv2
 */
class CfnDeploymentV2 extends cdk.CfnResource {
    /**
     * Create a new `AWS::ApiGatewayV2::Deployment`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDeploymentV2.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'apiId', this);
        this.apiId = props.apiId;
        this.description = props.description;
        this.stageName = props.stageName;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute('aws:cdk:cloudformation:type', CfnDeploymentV2.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute('aws:cdk:cloudformation:props', this.cfnProperties);
    }
    get cfnProperties() {
        return {
            apiId: this.apiId,
            description: this.description,
            stageName: this.stageName,
        };
    }
    renderProperties(props) {
        return cfnDeploymentV2PropsToCloudFormation(props);
    }
}
exports.CfnDeploymentV2 = CfnDeploymentV2;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDeploymentV2.CFN_RESOURCE_TYPE_NAME = 'AWS::ApiGatewayV2::Deployment';
/**
 * Determine whether the given properties match those of a `CfnDomainNameV2Props`
 *
 * @param properties - the TypeScript properties of a `CfnDomainNameV2Props`
 *
 * @returns the result of the validation.
 */
function CfnDomainNameV2PropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('domainName', cdk.requiredValidator)(properties.domainName));
    errors.collect(cdk.propertyValidator('domainName', cdk.validateString)(properties.domainName));
    errors.collect(cdk.propertyValidator('domainNameConfigurations', cdk.listValidator(CfnDomainNameV2_DomainNameConfigurationPropertyValidator))(properties.domainNameConfigurations));
    errors.collect(cdk.propertyValidator('tags', cdk.validateObject)(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnDomainNameV2Props"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ApiGatewayV2::DomainName` resource
 *
 * @param properties - the TypeScript properties of a `CfnDomainNameV2Props`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ApiGatewayV2::DomainName` resource.
 */
// @ts-ignore TS6133
function cfnDomainNameV2PropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDomainNameV2PropsValidator(properties).assertSuccess();
    return {
        DomainName: cdk.stringToCloudFormation(properties.domainName),
        DomainNameConfigurations: cdk.listMapper(cfnDomainNameV2DomainNameConfigurationPropertyToCloudFormation)(properties.domainNameConfigurations),
        Tags: cdk.objectToCloudFormation(properties.tags),
    };
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::DomainName`
 *
 * @cloudformationResource AWS::ApiGatewayV2::DomainName
 * @stability deprecated
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html
 * @deprecated moved to package aws-apigatewayv2
 */
class CfnDomainNameV2 extends cdk.CfnResource {
    /**
     * Create a new `AWS::ApiGatewayV2::DomainName`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDomainNameV2.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'domainName', this);
        this.attrRegionalDomainName = cdk.Token.asString(this.getAtt('RegionalDomainName'));
        this.attrRegionalHostedZoneId = cdk.Token.asString(this.getAtt('RegionalHostedZoneId'));
        this.domainName = props.domainName;
        this.domainNameConfigurations = props.domainNameConfigurations;
        this.tags = new cdk.TagManager(cdk.TagType.MAP, 'AWS::ApiGatewayV2::DomainName', props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute('aws:cdk:cloudformation:type', CfnDomainNameV2.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute('aws:cdk:cloudformation:props', this.cfnProperties);
    }
    get cfnProperties() {
        return {
            domainName: this.domainName,
            domainNameConfigurations: this.domainNameConfigurations,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnDomainNameV2PropsToCloudFormation(props);
    }
}
exports.CfnDomainNameV2 = CfnDomainNameV2;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDomainNameV2.CFN_RESOURCE_TYPE_NAME = 'AWS::ApiGatewayV2::DomainName';
/**
 * Determine whether the given properties match those of a `DomainNameConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `DomainNameConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnDomainNameV2_DomainNameConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('certificateArn', cdk.validateString)(properties.certificateArn));
    errors.collect(cdk.propertyValidator('certificateName', cdk.validateString)(properties.certificateName));
    errors.collect(cdk.propertyValidator('endpointType', cdk.validateString)(properties.endpointType));
    return errors.wrap('supplied properties not correct for "DomainNameConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ApiGatewayV2::DomainName.DomainNameConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `DomainNameConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ApiGatewayV2::DomainName.DomainNameConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnDomainNameV2DomainNameConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDomainNameV2_DomainNameConfigurationPropertyValidator(properties).assertSuccess();
    return {
        CertificateArn: cdk.stringToCloudFormation(properties.certificateArn),
        CertificateName: cdk.stringToCloudFormation(properties.certificateName),
        EndpointType: cdk.stringToCloudFormation(properties.endpointType),
    };
}
/**
 * Determine whether the given properties match those of a `CfnIntegrationV2Props`
 *
 * @param properties - the TypeScript properties of a `CfnIntegrationV2Props`
 *
 * @returns the result of the validation.
 */
function CfnIntegrationV2PropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('apiId', cdk.requiredValidator)(properties.apiId));
    errors.collect(cdk.propertyValidator('apiId', cdk.validateString)(properties.apiId));
    errors.collect(cdk.propertyValidator('connectionType', cdk.validateString)(properties.connectionType));
    errors.collect(cdk.propertyValidator('contentHandlingStrategy', cdk.validateString)(properties.contentHandlingStrategy));
    errors.collect(cdk.propertyValidator('credentialsArn', cdk.validateString)(properties.credentialsArn));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('integrationMethod', cdk.validateString)(properties.integrationMethod));
    errors.collect(cdk.propertyValidator('integrationType', cdk.requiredValidator)(properties.integrationType));
    errors.collect(cdk.propertyValidator('integrationType', cdk.validateString)(properties.integrationType));
    errors.collect(cdk.propertyValidator('integrationUri', cdk.validateString)(properties.integrationUri));
    errors.collect(cdk.propertyValidator('passthroughBehavior', cdk.validateString)(properties.passthroughBehavior));
    errors.collect(cdk.propertyValidator('payloadFormatVersion', cdk.validateString)(properties.payloadFormatVersion));
    errors.collect(cdk.propertyValidator('requestParameters', cdk.validateObject)(properties.requestParameters));
    errors.collect(cdk.propertyValidator('requestTemplates', cdk.validateObject)(properties.requestTemplates));
    errors.collect(cdk.propertyValidator('templateSelectionExpression', cdk.validateString)(properties.templateSelectionExpression));
    errors.collect(cdk.propertyValidator('timeoutInMillis', cdk.validateNumber)(properties.timeoutInMillis));
    return errors.wrap('supplied properties not correct for "CfnIntegrationV2Props"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Integration` resource
 *
 * @param properties - the TypeScript properties of a `CfnIntegrationV2Props`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Integration` resource.
 */
// @ts-ignore TS6133
function cfnIntegrationV2PropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnIntegrationV2PropsValidator(properties).assertSuccess();
    return {
        ApiId: cdk.stringToCloudFormation(properties.apiId),
        IntegrationType: cdk.stringToCloudFormation(properties.integrationType),
        ConnectionType: cdk.stringToCloudFormation(properties.connectionType),
        ContentHandlingStrategy: cdk.stringToCloudFormation(properties.contentHandlingStrategy),
        CredentialsArn: cdk.stringToCloudFormation(properties.credentialsArn),
        Description: cdk.stringToCloudFormation(properties.description),
        IntegrationMethod: cdk.stringToCloudFormation(properties.integrationMethod),
        IntegrationUri: cdk.stringToCloudFormation(properties.integrationUri),
        PassthroughBehavior: cdk.stringToCloudFormation(properties.passthroughBehavior),
        PayloadFormatVersion: cdk.stringToCloudFormation(properties.payloadFormatVersion),
        RequestParameters: cdk.objectToCloudFormation(properties.requestParameters),
        RequestTemplates: cdk.objectToCloudFormation(properties.requestTemplates),
        TemplateSelectionExpression: cdk.stringToCloudFormation(properties.templateSelectionExpression),
        TimeoutInMillis: cdk.numberToCloudFormation(properties.timeoutInMillis),
    };
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::Integration`
 *
 * @cloudformationResource AWS::ApiGatewayV2::Integration
 * @stability deprecated
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html
 * @deprecated moved to package aws-apigatewayv2
 */
class CfnIntegrationV2 extends cdk.CfnResource {
    /**
     * Create a new `AWS::ApiGatewayV2::Integration`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnIntegrationV2.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'apiId', this);
        cdk.requireProperty(props, 'integrationType', this);
        this.apiId = props.apiId;
        this.integrationType = props.integrationType;
        this.connectionType = props.connectionType;
        this.contentHandlingStrategy = props.contentHandlingStrategy;
        this.credentialsArn = props.credentialsArn;
        this.description = props.description;
        this.integrationMethod = props.integrationMethod;
        this.integrationUri = props.integrationUri;
        this.passthroughBehavior = props.passthroughBehavior;
        this.payloadFormatVersion = props.payloadFormatVersion;
        this.requestParameters = props.requestParameters;
        this.requestTemplates = props.requestTemplates;
        this.templateSelectionExpression = props.templateSelectionExpression;
        this.timeoutInMillis = props.timeoutInMillis;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute('aws:cdk:cloudformation:type', CfnIntegrationV2.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute('aws:cdk:cloudformation:props', this.cfnProperties);
    }
    get cfnProperties() {
        return {
            apiId: this.apiId,
            integrationType: this.integrationType,
            connectionType: this.connectionType,
            contentHandlingStrategy: this.contentHandlingStrategy,
            credentialsArn: this.credentialsArn,
            description: this.description,
            integrationMethod: this.integrationMethod,
            integrationUri: this.integrationUri,
            passthroughBehavior: this.passthroughBehavior,
            payloadFormatVersion: this.payloadFormatVersion,
            requestParameters: this.requestParameters,
            requestTemplates: this.requestTemplates,
            templateSelectionExpression: this.templateSelectionExpression,
            timeoutInMillis: this.timeoutInMillis,
        };
    }
    renderProperties(props) {
        return cfnIntegrationV2PropsToCloudFormation(props);
    }
}
exports.CfnIntegrationV2 = CfnIntegrationV2;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnIntegrationV2.CFN_RESOURCE_TYPE_NAME = 'AWS::ApiGatewayV2::Integration';
/**
 * Determine whether the given properties match those of a `CfnIntegrationResponseV2Props`
 *
 * @param properties - the TypeScript properties of a `CfnIntegrationResponseV2Props`
 *
 * @returns the result of the validation.
 */
function CfnIntegrationResponseV2PropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('apiId', cdk.requiredValidator)(properties.apiId));
    errors.collect(cdk.propertyValidator('apiId', cdk.validateString)(properties.apiId));
    errors.collect(cdk.propertyValidator('contentHandlingStrategy', cdk.validateString)(properties.contentHandlingStrategy));
    errors.collect(cdk.propertyValidator('integrationId', cdk.requiredValidator)(properties.integrationId));
    errors.collect(cdk.propertyValidator('integrationId', cdk.validateString)(properties.integrationId));
    errors.collect(cdk.propertyValidator('integrationResponseKey', cdk.requiredValidator)(properties.integrationResponseKey));
    errors.collect(cdk.propertyValidator('integrationResponseKey', cdk.validateString)(properties.integrationResponseKey));
    errors.collect(cdk.propertyValidator('responseParameters', cdk.validateObject)(properties.responseParameters));
    errors.collect(cdk.propertyValidator('responseTemplates', cdk.validateObject)(properties.responseTemplates));
    errors.collect(cdk.propertyValidator('templateSelectionExpression', cdk.validateString)(properties.templateSelectionExpression));
    return errors.wrap('supplied properties not correct for "CfnIntegrationResponseV2Props"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ApiGatewayV2::IntegrationResponse` resource
 *
 * @param properties - the TypeScript properties of a `CfnIntegrationResponseV2Props`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ApiGatewayV2::IntegrationResponse` resource.
 */
// @ts-ignore TS6133
function cfnIntegrationResponseV2PropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnIntegrationResponseV2PropsValidator(properties).assertSuccess();
    return {
        ApiId: cdk.stringToCloudFormation(properties.apiId),
        IntegrationId: cdk.stringToCloudFormation(properties.integrationId),
        IntegrationResponseKey: cdk.stringToCloudFormation(properties.integrationResponseKey),
        ContentHandlingStrategy: cdk.stringToCloudFormation(properties.contentHandlingStrategy),
        ResponseParameters: cdk.objectToCloudFormation(properties.responseParameters),
        ResponseTemplates: cdk.objectToCloudFormation(properties.responseTemplates),
        TemplateSelectionExpression: cdk.stringToCloudFormation(properties.templateSelectionExpression),
    };
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::IntegrationResponse`
 *
 * @cloudformationResource AWS::ApiGatewayV2::IntegrationResponse
 * @stability deprecated
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html
 * @deprecated moved to package aws-apigatewayv2
 */
class CfnIntegrationResponseV2 extends cdk.CfnResource {
    /**
     * Create a new `AWS::ApiGatewayV2::IntegrationResponse`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnIntegrationResponseV2.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'apiId', this);
        cdk.requireProperty(props, 'integrationId', this);
        cdk.requireProperty(props, 'integrationResponseKey', this);
        this.apiId = props.apiId;
        this.integrationId = props.integrationId;
        this.integrationResponseKey = props.integrationResponseKey;
        this.contentHandlingStrategy = props.contentHandlingStrategy;
        this.responseParameters = props.responseParameters;
        this.responseTemplates = props.responseTemplates;
        this.templateSelectionExpression = props.templateSelectionExpression;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute('aws:cdk:cloudformation:type', CfnIntegrationResponseV2.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute('aws:cdk:cloudformation:props', this.cfnProperties);
    }
    get cfnProperties() {
        return {
            apiId: this.apiId,
            integrationId: this.integrationId,
            integrationResponseKey: this.integrationResponseKey,
            contentHandlingStrategy: this.contentHandlingStrategy,
            responseParameters: this.responseParameters,
            responseTemplates: this.responseTemplates,
            templateSelectionExpression: this.templateSelectionExpression,
        };
    }
    renderProperties(props) {
        return cfnIntegrationResponseV2PropsToCloudFormation(props);
    }
}
exports.CfnIntegrationResponseV2 = CfnIntegrationResponseV2;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnIntegrationResponseV2.CFN_RESOURCE_TYPE_NAME = 'AWS::ApiGatewayV2::IntegrationResponse';
/**
 * Determine whether the given properties match those of a `CfnModelV2Props`
 *
 * @param properties - the TypeScript properties of a `CfnModelV2Props`
 *
 * @returns the result of the validation.
 */
function CfnModelV2PropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('apiId', cdk.requiredValidator)(properties.apiId));
    errors.collect(cdk.propertyValidator('apiId', cdk.validateString)(properties.apiId));
    errors.collect(cdk.propertyValidator('contentType', cdk.validateString)(properties.contentType));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('schema', cdk.requiredValidator)(properties.schema));
    errors.collect(cdk.propertyValidator('schema', cdk.validateObject)(properties.schema));
    return errors.wrap('supplied properties not correct for "CfnModelV2Props"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Model` resource
 *
 * @param properties - the TypeScript properties of a `CfnModelV2Props`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Model` resource.
 */
// @ts-ignore TS6133
function cfnModelV2PropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelV2PropsValidator(properties).assertSuccess();
    return {
        ApiId: cdk.stringToCloudFormation(properties.apiId),
        Name: cdk.stringToCloudFormation(properties.name),
        Schema: cdk.objectToCloudFormation(properties.schema),
        ContentType: cdk.stringToCloudFormation(properties.contentType),
        Description: cdk.stringToCloudFormation(properties.description),
    };
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::Model`
 *
 * @cloudformationResource AWS::ApiGatewayV2::Model
 * @stability deprecated
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-model.html
 * @deprecated moved to package aws-apigatewayv2
 */
class CfnModelV2 extends cdk.CfnResource {
    /**
     * Create a new `AWS::ApiGatewayV2::Model`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnModelV2.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'apiId', this);
        cdk.requireProperty(props, 'name', this);
        cdk.requireProperty(props, 'schema', this);
        this.apiId = props.apiId;
        this.name = props.name;
        this.schema = props.schema;
        this.contentType = props.contentType;
        this.description = props.description;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute('aws:cdk:cloudformation:type', CfnModelV2.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute('aws:cdk:cloudformation:props', this.cfnProperties);
    }
    get cfnProperties() {
        return {
            apiId: this.apiId,
            name: this.name,
            schema: this.schema,
            contentType: this.contentType,
            description: this.description,
        };
    }
    renderProperties(props) {
        return cfnModelV2PropsToCloudFormation(props);
    }
}
exports.CfnModelV2 = CfnModelV2;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnModelV2.CFN_RESOURCE_TYPE_NAME = 'AWS::ApiGatewayV2::Model';
/**
 * Determine whether the given properties match those of a `CfnRouteV2Props`
 *
 * @param properties - the TypeScript properties of a `CfnRouteV2Props`
 *
 * @returns the result of the validation.
 */
function CfnRouteV2PropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('apiId', cdk.requiredValidator)(properties.apiId));
    errors.collect(cdk.propertyValidator('apiId', cdk.validateString)(properties.apiId));
    errors.collect(cdk.propertyValidator('apiKeyRequired', cdk.validateBoolean)(properties.apiKeyRequired));
    errors.collect(cdk.propertyValidator('authorizationScopes', cdk.listValidator(cdk.validateString))(properties.authorizationScopes));
    errors.collect(cdk.propertyValidator('authorizationType', cdk.validateString)(properties.authorizationType));
    errors.collect(cdk.propertyValidator('authorizerId', cdk.validateString)(properties.authorizerId));
    errors.collect(cdk.propertyValidator('modelSelectionExpression', cdk.validateString)(properties.modelSelectionExpression));
    errors.collect(cdk.propertyValidator('operationName', cdk.validateString)(properties.operationName));
    errors.collect(cdk.propertyValidator('requestModels', cdk.validateObject)(properties.requestModels));
    errors.collect(cdk.propertyValidator('requestParameters', cdk.validateObject)(properties.requestParameters));
    errors.collect(cdk.propertyValidator('routeKey', cdk.requiredValidator)(properties.routeKey));
    errors.collect(cdk.propertyValidator('routeKey', cdk.validateString)(properties.routeKey));
    errors.collect(cdk.propertyValidator('routeResponseSelectionExpression', cdk.validateString)(properties.routeResponseSelectionExpression));
    errors.collect(cdk.propertyValidator('target', cdk.validateString)(properties.target));
    return errors.wrap('supplied properties not correct for "CfnRouteV2Props"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Route` resource
 *
 * @param properties - the TypeScript properties of a `CfnRouteV2Props`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Route` resource.
 */
// @ts-ignore TS6133
function cfnRouteV2PropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRouteV2PropsValidator(properties).assertSuccess();
    return {
        ApiId: cdk.stringToCloudFormation(properties.apiId),
        RouteKey: cdk.stringToCloudFormation(properties.routeKey),
        ApiKeyRequired: cdk.booleanToCloudFormation(properties.apiKeyRequired),
        AuthorizationScopes: cdk.listMapper(cdk.stringToCloudFormation)(properties.authorizationScopes),
        AuthorizationType: cdk.stringToCloudFormation(properties.authorizationType),
        AuthorizerId: cdk.stringToCloudFormation(properties.authorizerId),
        ModelSelectionExpression: cdk.stringToCloudFormation(properties.modelSelectionExpression),
        OperationName: cdk.stringToCloudFormation(properties.operationName),
        RequestModels: cdk.objectToCloudFormation(properties.requestModels),
        RequestParameters: cdk.objectToCloudFormation(properties.requestParameters),
        RouteResponseSelectionExpression: cdk.stringToCloudFormation(properties.routeResponseSelectionExpression),
        Target: cdk.stringToCloudFormation(properties.target),
    };
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::Route`
 *
 * @cloudformationResource AWS::ApiGatewayV2::Route
 * @stability deprecated
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html
 * @deprecated moved to package aws-apigatewayv2
 */
class CfnRouteV2 extends cdk.CfnResource {
    /**
     * Create a new `AWS::ApiGatewayV2::Route`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnRouteV2.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'apiId', this);
        cdk.requireProperty(props, 'routeKey', this);
        this.apiId = props.apiId;
        this.routeKey = props.routeKey;
        this.apiKeyRequired = props.apiKeyRequired;
        this.authorizationScopes = props.authorizationScopes;
        this.authorizationType = props.authorizationType;
        this.authorizerId = props.authorizerId;
        this.modelSelectionExpression = props.modelSelectionExpression;
        this.operationName = props.operationName;
        this.requestModels = props.requestModels;
        this.requestParameters = props.requestParameters;
        this.routeResponseSelectionExpression = props.routeResponseSelectionExpression;
        this.target = props.target;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute('aws:cdk:cloudformation:type', CfnRouteV2.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute('aws:cdk:cloudformation:props', this.cfnProperties);
    }
    get cfnProperties() {
        return {
            apiId: this.apiId,
            routeKey: this.routeKey,
            apiKeyRequired: this.apiKeyRequired,
            authorizationScopes: this.authorizationScopes,
            authorizationType: this.authorizationType,
            authorizerId: this.authorizerId,
            modelSelectionExpression: this.modelSelectionExpression,
            operationName: this.operationName,
            requestModels: this.requestModels,
            requestParameters: this.requestParameters,
            routeResponseSelectionExpression: this.routeResponseSelectionExpression,
            target: this.target,
        };
    }
    renderProperties(props) {
        return cfnRouteV2PropsToCloudFormation(props);
    }
}
exports.CfnRouteV2 = CfnRouteV2;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnRouteV2.CFN_RESOURCE_TYPE_NAME = 'AWS::ApiGatewayV2::Route';
/**
 * Determine whether the given properties match those of a `ParameterConstraintsProperty`
 *
 * @param properties - the TypeScript properties of a `ParameterConstraintsProperty`
 *
 * @returns the result of the validation.
 */
function CfnRouteV2_ParameterConstraintsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('required', cdk.requiredValidator)(properties.required));
    errors.collect(cdk.propertyValidator('required', cdk.validateBoolean)(properties.required));
    return errors.wrap('supplied properties not correct for "ParameterConstraintsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Route.ParameterConstraints` resource
 *
 * @param properties - the TypeScript properties of a `ParameterConstraintsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Route.ParameterConstraints` resource.
 */
// @ts-ignore TS6133
function cfnRouteV2ParameterConstraintsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRouteV2_ParameterConstraintsPropertyValidator(properties).assertSuccess();
    return {
        Required: cdk.booleanToCloudFormation(properties.required),
    };
}
/**
 * Determine whether the given properties match those of a `CfnRouteResponseV2Props`
 *
 * @param properties - the TypeScript properties of a `CfnRouteResponseV2Props`
 *
 * @returns the result of the validation.
 */
function CfnRouteResponseV2PropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('apiId', cdk.requiredValidator)(properties.apiId));
    errors.collect(cdk.propertyValidator('apiId', cdk.validateString)(properties.apiId));
    errors.collect(cdk.propertyValidator('modelSelectionExpression', cdk.validateString)(properties.modelSelectionExpression));
    errors.collect(cdk.propertyValidator('responseModels', cdk.validateObject)(properties.responseModels));
    errors.collect(cdk.propertyValidator('responseParameters', cdk.validateObject)(properties.responseParameters));
    errors.collect(cdk.propertyValidator('routeId', cdk.requiredValidator)(properties.routeId));
    errors.collect(cdk.propertyValidator('routeId', cdk.validateString)(properties.routeId));
    errors.collect(cdk.propertyValidator('routeResponseKey', cdk.requiredValidator)(properties.routeResponseKey));
    errors.collect(cdk.propertyValidator('routeResponseKey', cdk.validateString)(properties.routeResponseKey));
    return errors.wrap('supplied properties not correct for "CfnRouteResponseV2Props"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ApiGatewayV2::RouteResponse` resource
 *
 * @param properties - the TypeScript properties of a `CfnRouteResponseV2Props`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ApiGatewayV2::RouteResponse` resource.
 */
// @ts-ignore TS6133
function cfnRouteResponseV2PropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRouteResponseV2PropsValidator(properties).assertSuccess();
    return {
        ApiId: cdk.stringToCloudFormation(properties.apiId),
        RouteId: cdk.stringToCloudFormation(properties.routeId),
        RouteResponseKey: cdk.stringToCloudFormation(properties.routeResponseKey),
        ModelSelectionExpression: cdk.stringToCloudFormation(properties.modelSelectionExpression),
        ResponseModels: cdk.objectToCloudFormation(properties.responseModels),
        ResponseParameters: cdk.objectToCloudFormation(properties.responseParameters),
    };
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::RouteResponse`
 *
 * @cloudformationResource AWS::ApiGatewayV2::RouteResponse
 * @stability deprecated
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-routeresponse.html
 * @deprecated moved to package aws-apigatewayv2
 */
class CfnRouteResponseV2 extends cdk.CfnResource {
    /**
     * Create a new `AWS::ApiGatewayV2::RouteResponse`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnRouteResponseV2.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'apiId', this);
        cdk.requireProperty(props, 'routeId', this);
        cdk.requireProperty(props, 'routeResponseKey', this);
        this.apiId = props.apiId;
        this.routeId = props.routeId;
        this.routeResponseKey = props.routeResponseKey;
        this.modelSelectionExpression = props.modelSelectionExpression;
        this.responseModels = props.responseModels;
        this.responseParameters = props.responseParameters;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute('aws:cdk:cloudformation:type', CfnRouteResponseV2.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute('aws:cdk:cloudformation:props', this.cfnProperties);
    }
    get cfnProperties() {
        return {
            apiId: this.apiId,
            routeId: this.routeId,
            routeResponseKey: this.routeResponseKey,
            modelSelectionExpression: this.modelSelectionExpression,
            responseModels: this.responseModels,
            responseParameters: this.responseParameters,
        };
    }
    renderProperties(props) {
        return cfnRouteResponseV2PropsToCloudFormation(props);
    }
}
exports.CfnRouteResponseV2 = CfnRouteResponseV2;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnRouteResponseV2.CFN_RESOURCE_TYPE_NAME = 'AWS::ApiGatewayV2::RouteResponse';
/**
 * Determine whether the given properties match those of a `ParameterConstraintsProperty`
 *
 * @param properties - the TypeScript properties of a `ParameterConstraintsProperty`
 *
 * @returns the result of the validation.
 */
function CfnRouteResponseV2_ParameterConstraintsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('required', cdk.requiredValidator)(properties.required));
    errors.collect(cdk.propertyValidator('required', cdk.validateBoolean)(properties.required));
    return errors.wrap('supplied properties not correct for "ParameterConstraintsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ApiGatewayV2::RouteResponse.ParameterConstraints` resource
 *
 * @param properties - the TypeScript properties of a `ParameterConstraintsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ApiGatewayV2::RouteResponse.ParameterConstraints` resource.
 */
// @ts-ignore TS6133
function cfnRouteResponseV2ParameterConstraintsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRouteResponseV2_ParameterConstraintsPropertyValidator(properties).assertSuccess();
    return {
        Required: cdk.booleanToCloudFormation(properties.required),
    };
}
/**
 * Determine whether the given properties match those of a `CfnStageV2Props`
 *
 * @param properties - the TypeScript properties of a `CfnStageV2Props`
 *
 * @returns the result of the validation.
 */
function CfnStageV2PropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('accessLogSettings', CfnStageV2_AccessLogSettingsPropertyValidator)(properties.accessLogSettings));
    errors.collect(cdk.propertyValidator('apiId', cdk.requiredValidator)(properties.apiId));
    errors.collect(cdk.propertyValidator('apiId', cdk.validateString)(properties.apiId));
    errors.collect(cdk.propertyValidator('autoDeploy', cdk.validateBoolean)(properties.autoDeploy));
    errors.collect(cdk.propertyValidator('clientCertificateId', cdk.validateString)(properties.clientCertificateId));
    errors.collect(cdk.propertyValidator('defaultRouteSettings', CfnStageV2_RouteSettingsPropertyValidator)(properties.defaultRouteSettings));
    errors.collect(cdk.propertyValidator('deploymentId', cdk.validateString)(properties.deploymentId));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('routeSettings', cdk.validateObject)(properties.routeSettings));
    errors.collect(cdk.propertyValidator('stageName', cdk.requiredValidator)(properties.stageName));
    errors.collect(cdk.propertyValidator('stageName', cdk.validateString)(properties.stageName));
    errors.collect(cdk.propertyValidator('stageVariables', cdk.validateObject)(properties.stageVariables));
    errors.collect(cdk.propertyValidator('tags', cdk.validateObject)(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnStageV2Props"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Stage` resource
 *
 * @param properties - the TypeScript properties of a `CfnStageV2Props`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Stage` resource.
 */
// @ts-ignore TS6133
function cfnStageV2PropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnStageV2PropsValidator(properties).assertSuccess();
    return {
        ApiId: cdk.stringToCloudFormation(properties.apiId),
        StageName: cdk.stringToCloudFormation(properties.stageName),
        AccessLogSettings: cfnStageV2AccessLogSettingsPropertyToCloudFormation(properties.accessLogSettings),
        AutoDeploy: cdk.booleanToCloudFormation(properties.autoDeploy),
        ClientCertificateId: cdk.stringToCloudFormation(properties.clientCertificateId),
        DefaultRouteSettings: cfnStageV2RouteSettingsPropertyToCloudFormation(properties.defaultRouteSettings),
        DeploymentId: cdk.stringToCloudFormation(properties.deploymentId),
        Description: cdk.stringToCloudFormation(properties.description),
        RouteSettings: cdk.objectToCloudFormation(properties.routeSettings),
        StageVariables: cdk.objectToCloudFormation(properties.stageVariables),
        Tags: cdk.objectToCloudFormation(properties.tags),
    };
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::Stage`
 *
 * @cloudformationResource AWS::ApiGatewayV2::Stage
 * @stability deprecated
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html
 * @deprecated moved to package aws-apigatewayv2
 */
class CfnStageV2 extends cdk.CfnResource {
    /**
     * Create a new `AWS::ApiGatewayV2::Stage`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnStageV2.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'apiId', this);
        cdk.requireProperty(props, 'stageName', this);
        this.apiId = props.apiId;
        this.stageName = props.stageName;
        this.accessLogSettings = props.accessLogSettings;
        this.autoDeploy = props.autoDeploy;
        this.clientCertificateId = props.clientCertificateId;
        this.defaultRouteSettings = props.defaultRouteSettings;
        this.deploymentId = props.deploymentId;
        this.description = props.description;
        this.routeSettings = props.routeSettings;
        this.stageVariables = props.stageVariables;
        this.tags = new cdk.TagManager(cdk.TagType.MAP, 'AWS::ApiGatewayV2::Stage', props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute('aws:cdk:cloudformation:type', CfnStageV2.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute('aws:cdk:cloudformation:props', this.cfnProperties);
    }
    get cfnProperties() {
        return {
            apiId: this.apiId,
            stageName: this.stageName,
            accessLogSettings: this.accessLogSettings,
            autoDeploy: this.autoDeploy,
            clientCertificateId: this.clientCertificateId,
            defaultRouteSettings: this.defaultRouteSettings,
            deploymentId: this.deploymentId,
            description: this.description,
            routeSettings: this.routeSettings,
            stageVariables: this.stageVariables,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnStageV2PropsToCloudFormation(props);
    }
}
exports.CfnStageV2 = CfnStageV2;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnStageV2.CFN_RESOURCE_TYPE_NAME = 'AWS::ApiGatewayV2::Stage';
/**
 * Determine whether the given properties match those of a `AccessLogSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `AccessLogSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnStageV2_AccessLogSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('destinationArn', cdk.validateString)(properties.destinationArn));
    errors.collect(cdk.propertyValidator('format', cdk.validateString)(properties.format));
    return errors.wrap('supplied properties not correct for "AccessLogSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Stage.AccessLogSettings` resource
 *
 * @param properties - the TypeScript properties of a `AccessLogSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Stage.AccessLogSettings` resource.
 */
// @ts-ignore TS6133
function cfnStageV2AccessLogSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnStageV2_AccessLogSettingsPropertyValidator(properties).assertSuccess();
    return {
        DestinationArn: cdk.stringToCloudFormation(properties.destinationArn),
        Format: cdk.stringToCloudFormation(properties.format),
    };
}
/**
 * Determine whether the given properties match those of a `RouteSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `RouteSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnStageV2_RouteSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('dataTraceEnabled', cdk.validateBoolean)(properties.dataTraceEnabled));
    errors.collect(cdk.propertyValidator('detailedMetricsEnabled', cdk.validateBoolean)(properties.detailedMetricsEnabled));
    errors.collect(cdk.propertyValidator('loggingLevel', cdk.validateString)(properties.loggingLevel));
    errors.collect(cdk.propertyValidator('throttlingBurstLimit', cdk.validateNumber)(properties.throttlingBurstLimit));
    errors.collect(cdk.propertyValidator('throttlingRateLimit', cdk.validateNumber)(properties.throttlingRateLimit));
    return errors.wrap('supplied properties not correct for "RouteSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Stage.RouteSettings` resource
 *
 * @param properties - the TypeScript properties of a `RouteSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Stage.RouteSettings` resource.
 */
// @ts-ignore TS6133
function cfnStageV2RouteSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnStageV2_RouteSettingsPropertyValidator(properties).assertSuccess();
    return {
        DataTraceEnabled: cdk.booleanToCloudFormation(properties.dataTraceEnabled),
        DetailedMetricsEnabled: cdk.booleanToCloudFormation(properties.detailedMetricsEnabled),
        LoggingLevel: cdk.stringToCloudFormation(properties.loggingLevel),
        ThrottlingBurstLimit: cdk.numberToCloudFormation(properties.throttlingBurstLimit),
        ThrottlingRateLimit: cdk.numberToCloudFormation(properties.throttlingRateLimit),
    };
}
//# sourceMappingURL=data:application/json;base64,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