import sys, os, shutil
from .unitypredictcli import UnityPredictCli
from .unitypredictUtils import ReturnValues as Ret
import argparse

def main():
    cliExec = "UnityPredict SDK"
    parser = argparse.ArgumentParser(
            description="Welcome to {}".format(cliExec)
    )
   
    parser.add_argument("--configure", action="store_true", help="unitypredict --configure")
    parser.add_argument("--list_profiles", action="store_true", help="unitypredict --list_profiles")
    parser.add_argument("--engine", action="store_true", help="unitypredict --engine <options>")
    parser.add_argument("--create", default=None, help="""unitypredict --engine --create <EngineName>""")
    parser.add_argument("--remove", default=None, help="""unitypredict --engine --remove <EngineName>""")
    parser.add_argument("--run", action="store_true", help="""unitypredict --engine --run""")
    parser.add_argument("--deploy", action="store_true", help="""unitypredict --engine --deploy""")
    parser.add_argument("--delete", action="store_true", help="""unitypredict --engine --delete""")
    parser.add_argument("--env", default="prod", help=argparse.SUPPRESS)


    args = parser.parse_args()

    num_args = len(sys.argv) - 1
    
    if (num_args == 0):
        parser.print_help()
        sys.exit(0)

    cliDriver = UnityPredictCli()

    if args.configure:
        inputApiKey = input("Enter your UnityPredict account API Key: ")
        inputApiKey = inputApiKey.strip()
        ret = cliDriver.configureCredentials(uptApiKey=inputApiKey)
        sys.exit(0)

    if args.list_profiles:
        cliDriver.showProfiles()
        sys.exit(0)

    if args.engine:
        
        if args.create != None:
            print (f"Creating Engine {args.create} ...")
            ret = cliDriver.createEngine(engineName=args.create)
            if ret == Ret.ENGINE_CREATE_ERROR:
                cliDriver.removeEngine(engineName=args.create)
                print (f"Removing Engine {args.create} due to Engine Creation errors!")
            else:
                print (f"Created Engine {args.create} Successfully!")
            sys.exit(0)

        elif args.remove != None:
            print (f"Removing Engine {args.remove} ...")
            ret = cliDriver.removeEngine(engineName=args.remove)
            if ret == Ret.ENGINE_REMOVE_SUCCESS:
                print(f"Removed the engine {args.remove} Successfully!")
            elif ret == Ret.ENGINE_REMOVE_ERROR:
                print(f"Engine {args.remove} not detected!")
            sys.exit(0)
        
        elif args.run:

            # Change to parent dir for proper engine validation in local system
            engineDir = os.getcwd()
            engineName = os.path.basename(engineDir)
            engineParent = os.path.dirname(engineDir)

            os.chdir(engineParent)

            print (f"Run engine: {engineName} ...")
            cliDriver.runEngine(engineName=engineName)
            
            os.chdir(engineDir)
            sys.exit(0)
        
        elif args.deploy:

            # Change to parent dir for proper engine validation in local system
            engineDir = os.getcwd()
            engineName = os.path.basename(engineDir)
            engineParent = os.path.dirname(engineDir)

            os.chdir(engineParent)

            print (f"Deploying {engineName} ... ")
            ret = cliDriver.deployEngine(engineName=engineName, uptEnv=args.env)
            if ret == Ret.ENGINE_DEPLOY_ERROR:
                print (f"Error in deploying Engine {engineName}")
            else:
                print (f"Deployed Engine {engineName} on UnityPredict Successfully!")
            
            os.chdir(engineDir)
            sys.exit(0)

        elif args.delete:

            # Change to parent dir for proper engine validation in local system
            engineDir = os.getcwd()
            engineName = os.path.basename(engineDir)
            engineParent = os.path.dirname(engineDir)

            os.chdir(engineParent)

            print (f"Deleting {engineName} ... ")
            ret = cliDriver.deleteDeployedEngine(engineName=engineName, uptEnv=args.env)
            if ret == Ret.UPT_ENGINE_DELETE_ERROR:
                print (f"Error in deleting Engine {engineName} on UnityPredict")
            else:
                print (f"Deleted Engine {engineName} on UnityPredict Successfully!")
            os.chdir(engineDir)
            sys.exit(0)

        else:
            print ("Incomplete arguements present. Please check the help section for the usage")
            parser.print_help()
        sys.exit(0)
    


