# simplemagic

Simple file magic. We try to get file's mimetype using 'file-magic', 'command file' and 'puremagic'. On linux we need system package 'file-libs' which mostly already installed. On MacOS we need system package 'libimage' which can be installed by 'brew install libmagic'. On windows we need file command which can be install by 'pacman -S file' within msys2. If system package missing, we try to get the file's mimetype using 'puremagic' which is write in pure python without any extra depends.

## Install

```
pip3 install simplemagic
```

## System requirements

### Linux

- file-libs

Mostly it is installed already, and you can installed it with command:

```
yum install file-libs
```

### MacOS

- libmagic

You can installed it with command:

```
brew install libmagic
```

### Windows

libmagic mostly not working on windows. Suggest you install msys2 on in system, and in msys2 you can install libmagic with command:

```
pacman -S file
```

Add msys2's bin path to your system's PATH env. We can call the external command `file` to get the mimetype of a file.

## APIS

- simplemagic.get_mimetype_by_stream
- simplemagic.get_mimetype_by_filename
- simplemagic.guess_all_extensions
- simplemagic.is_file_content_matches_with_file_extension # mostly we just use this function to check if the file cotent is matches with the file extension.

You can read the source code to find other private apis which maybe you will need to reset the global settings or running env.

## Examples

```
import simplemagic

ext = ".docx"
filename = "ok.docx"
mimetype = simplemagic.get_mimetype_by_filename(filename)
ok_exts = simplemagic.guess_all_extensions(mimetype)
if ext in ok_exts:
    print("the file content is match with the file suffix...")
```

## Example files detected

```
ok.bash_history: text/plain
ok.bash_profile: text/plain
ok.bashrc: text/plain
ok.conf: text/plain
ok.coverage: application/vnd.sqlite3
ok.csv: text/plain
ok.dat: application/octet-stream
ok.doc: application/msword
ok.docx: application/vnd.openxmlformats-officedocument.wordprocessingml.document
ok.dot: application/vnd.openxmlformats-officedocument.wordprocessingml.document
ok.dps: application/vnd.openxmlformats-officedocument.presentationml.presentation
ok.dpt: application/vnd.openxmlformats-officedocument.presentationml.presentation
ok.et: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet
ok.ett: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet
ok.gif: image/gif
ok.gitignore: text/plain
ok.htaccess: text/plain
ok.in: text/plain
ok.ini: text/plain
ok.java: text/x-java
ok.jpg: image/jpeg
ok.less: text/plain
ok.log: text/plain
ok.md: text/plain
ok.pages: application/zip
ok.pdf: application/pdf
ok.pl: text/x-perl
ok.png: image/png
ok.pptx: application/vnd.openxmlformats-officedocument.presentationml.presentation
ok.properties: text/plain
ok.py: text/x-script.python
ok.rpm: application/x-rpm
ok.scss: text/plain
ok.sh: text/x-shellscript
ok.sql: text/plain
ok.svg: image/svg+xml
ok.tar.gz: application/gzip
ok.ttf: font/sfnt
ok.txt: text/plain
ok.txt.bz2: application/x-bzip2
ok.whl: application/zip
ok.woff: application/octet-stream
ok.woff2: application/octet-stream
ok.wps: application/vnd.openxmlformats-officedocument.wordprocessingml.document
ok.wpt: application/vnd.openxmlformats-officedocument.wordprocessingml.document
ok.wsdl: text/xml
ok.xlsx: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet
ok.xmind: application/zip
ok.xml: text/xml
ok.xsl: text/xml
ok.yml: text/plain
ok.zip: application/zip
private.DS_Store: application/octet-stream
private.bpmn: text/xml
private.cab: application/vnd.ms-cab-compressed
private.class: application/x-java-applet
private.dll: application/x-dosexec
private.dmg: application/x-bzip2
private.doc: application/msword
private.dwg: image/vnd.dwg
private.fla: application/CDFV2
private.ftl: text/html
private.ico: image/vnd.microsoft.icon
private.img: application/octet-stream
private.inf: text/plain
private.jsp: text/html
private.mht: message/rfc822
private.mp4: video/mp4
private.mpp: application/vnd.ms-office
private.msi: application/x-msi
private.pcap: application/vnd.tcpdump.pcap
private.pps: application/vnd.ms-powerpoint
private.ppt: application/vnd.ms-powerpoint
private.psd: image/vnd.adobe.photoshop
private.pyc: application/x-bytecode.python
private.rar: application/x-rar
private.reg: text/x-ms-regedit
private.swf: application/x-shockwave-flash
private.tar: application/x-tar
private.tif: image/tiff
private.vsd: application/vnd.ms-office
private.xls: application/vnd.ms-excel
private.xps: application/zip
private.xsd: text/xml
```

## Notice

Always upgrade your libmagic to the latest, old libmagic may get wrong answer.

## Compatibility

- test passed on python3.6, python3.7, python3.8, python3.9 and python3.10
- test failed on python2.7, python3.3, python3.4, python3.5

## Releases

### v0.1.0

- First release.

### v0.1.1

- Recover stream position after mimetype detect.
- Fix small file handling problem in puremagic.
- Fix .gz extension problem.
- Fix .bz2 extension problem.


### v0.1.5

- Put function is_file_content_matches_with_file_extension to public.
- Using magic.detect_from_fobj instead of magic.detect_from_content to improve the recognition.
- Change register_mimetype_extensions' parameters, and fix the problem.
- Fix .dps, .dpt, .et, .ett extension problems.
- Fix .dox problem.
- Fix .mptt problem.
- Fix .csv problem.
- Fix .pcap problem.
- Fix .rpm problem.
- Fix .dmg problem.
- Fix .reg problem.
- Fix .dwg problem.
- Fix .xps problem.
- Fix .ttf problem.
- Fix .woff and .woff2 problem.
- Fix java .class problem.
- Fix .jsp problem.
- Fix .less and .scss problem.
- Fix .pyc problem.
- Fix .fla problem.
- Fix .vsd problem.
