/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.space;

import eu.quanticol.moonlight.core.base.MoonLightRecord;
import eu.quanticol.moonlight.core.space.LocationService;
import eu.quanticol.moonlight.core.space.LocationServiceLoader;
import eu.quanticol.moonlight.core.space.SpatialModel;
import eu.quanticol.moonlight.io.AbstractFileByRowReader;
import eu.quanticol.moonlight.io.json.IllegalFileFormat;
import eu.quanticol.moonlight.offline.signal.IllegalValueException;
import eu.quanticol.moonlight.offline.signal.RecordHandler;
import eu.quanticol.moonlight.space.GraphModel;
import eu.quanticol.moonlight.space.LocationServiceList;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class TRALocationServiceLoader
extends AbstractFileByRowReader
implements LocationServiceLoader {
    public static final String LOCATIONS_KEY = "LOCATIONS";
    private static final String TIME_KEY = "TIME";
    private static final String TRANSITIONS_KEY = "TRANSITIONS";

    @Override
    public LocationService<Double, MoonLightRecord> load(RecordHandler handler, File input) throws IOException, IllegalFileFormat {
        return this.load(handler, this.getRows(input));
    }

    @Override
    public LocationService<Double, MoonLightRecord> load(RecordHandler handler, String input) throws IllegalFileFormat {
        return this.load(handler, this.getRows(input));
    }

    private LocationService<Double, MoonLightRecord> load(RecordHandler handler, List<AbstractFileByRowReader.Row> rows) throws IllegalFileFormat {
        Iterator<AbstractFileByRowReader.Row> iterator = rows.iterator();
        int size = this.parseSize(iterator);
        return this.parseLocationService(size, handler, iterator);
    }

    private LocationService<Double, MoonLightRecord> parseLocationService(int size, RecordHandler handler, Iterator<AbstractFileByRowReader.Row> iterator) throws IllegalFileFormat {
        LocationServiceList<MoonLightRecord> loc = new LocationServiceList<MoonLightRecord>();
        AbstractFileByRowReader.Row row = this.nextNotEmpty(iterator);
        if (this.isTimeRow(Objects.requireNonNull(row))) {
            do {
                double time = this.parseTime(row);
                row = Objects.requireNonNull(this.nextNotEmpty(iterator));
                loc.add(time, this.parseGraph(handler, size, this.getNumberOfTransitions(row), iterator));
            } while ((row = this.nextNotEmpty(iterator)) != null);
        } else if (this.isDeclarationOfTransition(row)) {
            loc.add(0.0, this.parseGraph(handler, size, this.getNumberOfTransitions(row), iterator));
        } else {
            throw new IllegalFileFormat("Error: either TIME or TRANSITIONS is expected at line " + row.getLine());
        }
        return loc;
    }

    private SpatialModel<MoonLightRecord> parseGraph(RecordHandler handler, int size, int numberOfTransitions, Iterator<AbstractFileByRowReader.Row> iterator) throws IllegalFileFormat {
        GraphModel<MoonLightRecord> model = new GraphModel<MoonLightRecord>(size);
        for (int i = 0; i < numberOfTransitions; ++i) {
            AbstractFileByRowReader.Row row = Objects.requireNonNull(this.nextNotEmpty(iterator));
            this.addTransition(row, model, handler);
        }
        return model;
    }

    private void addTransition(AbstractFileByRowReader.Row row, GraphModel<MoonLightRecord> model, RecordHandler handler) throws IllegalFileFormat {
        String[] elements = row.get(0).trim().split(" ");
        if (elements.length > 2) {
            try {
                int src = Integer.parseInt(elements[0]) - 1;
                int trg = Integer.parseInt(elements[1]) - 1;
                MoonLightRecord v = handler.fromStringArray(elements, 2, elements.length);
                model.add(src, v, trg);
                return;
            }
            catch (IllegalValueException | NumberFormatException e) {
                e.printStackTrace();
            }
        }
        throw TRALocationServiceLoader.illegal(row.get(0), "<int> <int> <val1>;...;<valn>");
    }

    private boolean isDeclarationOfTransition(AbstractFileByRowReader.Row row) {
        if (row.get(0).startsWith(TRANSITIONS_KEY)) {
            try {
                Integer.parseInt(row.get(0).substring(TRANSITIONS_KEY.length()).trim());
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    private int getNumberOfTransitions(AbstractFileByRowReader.Row row) throws IllegalFileFormat {
        if (row.get(0).startsWith(TRANSITIONS_KEY)) {
            try {
                return Integer.parseInt(row.get(0).substring(TRANSITIONS_KEY.length()).trim());
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        throw TRALocationServiceLoader.illegal(row.get(0), "TRANSITIONS <int>");
    }

    private double parseTime(AbstractFileByRowReader.Row row) throws IllegalFileFormat {
        if (row.get(0).startsWith(TIME_KEY)) {
            try {
                return Double.parseDouble(row.get(0).substring(TIME_KEY.length()).trim());
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        throw TRALocationServiceLoader.illegal(row.get(0), "TIME <double>");
    }

    private boolean isTimeRow(AbstractFileByRowReader.Row row) {
        if (row.get(0).startsWith(TIME_KEY)) {
            try {
                Double.parseDouble(row.get(0).substring(TIME_KEY.length()).trim());
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    private AbstractFileByRowReader.Row nextNotEmpty(Iterator<AbstractFileByRowReader.Row> iterator) {
        while (iterator.hasNext()) {
            AbstractFileByRowReader.Row r = iterator.next();
            if (r.isEmpty()) continue;
            return r;
        }
        return null;
    }

    private int parseSize(Iterator<AbstractFileByRowReader.Row> iterator) throws IllegalFileFormat {
        AbstractFileByRowReader.Row row = this.nextNotEmpty(iterator);
        if (row != null) {
            String element = row.get(0);
            return this.parseSize(element);
        }
        throw new IllegalFileFormat("Declarations of number of localities is missing the the beginning of file.");
    }

    private int parseSize(String element) throws IllegalFileFormat {
        if (element.startsWith(LOCATIONS_KEY)) {
            try {
                return Integer.parseInt(element.substring(LOCATIONS_KEY.length()).trim());
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        throw new IllegalFileFormat("Error: 'LOCATIONS <int>' is expected, found " + element);
    }

    private static IllegalFileFormat illegal(String line, String expected) {
        return new IllegalFileFormat("Syntax error at line " + line + ": expected " + expected + " , found " + line);
    }
}

