/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.online.monitoring.temporal;

import eu.quanticol.moonlight.core.base.Box;
import eu.quanticol.moonlight.core.formula.Interval;
import eu.quanticol.moonlight.core.signal.SignalDomain;
import eu.quanticol.moonlight.core.signal.TimeSignal;
import eu.quanticol.moonlight.online.algorithms.TemporalOp;
import eu.quanticol.moonlight.online.monitoring.OnlineMonitor;
import eu.quanticol.moonlight.online.signal.OnlineSignal;
import eu.quanticol.moonlight.online.signal.TimeChain;
import eu.quanticol.moonlight.online.signal.Update;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BinaryOperator;

public class TemporalOpMonitor<V, R extends Comparable<R>>
implements OnlineMonitor<Double, V, Box<R>> {
    private final BinaryOperator<Box<R>> op;
    private final Interval horizon;
    private final OnlineSignal<R> rho;
    private final OnlineMonitor<Double, V, Box<R>> argumentMonitor;

    public TemporalOpMonitor(OnlineMonitor<Double, V, Box<R>> argument, BinaryOperator<Box<R>> binaryOp, Interval timeHorizon, SignalDomain<R> interpretation) {
        this.op = binaryOp;
        this.horizon = timeHorizon;
        this.rho = new OnlineSignal<R>(interpretation);
        this.argumentMonitor = argument;
    }

    @Override
    public List<TimeChain<Double, Box<R>>> monitor(Update<Double, V> signalUpdate) {
        List<TimeChain<Double, Box<R>>> argUpdates = this.argumentMonitor.monitor(signalUpdate);
        TimeChain<Double, Box<R>> s = this.argumentMonitor.getResult().getSegments();
        ArrayList<TimeChain<Double, Box<R>>> updates = new ArrayList<TimeChain<Double, Box<R>>>();
        for (TimeChain<Double, Box<R>> argU : argUpdates) {
            updates.addAll(TemporalOp.slidingWindow(s, argU, this.horizon, this.op));
        }
        updates.forEach(this.rho::refine);
        return updates;
    }

    @Override
    public List<TimeChain<Double, Box<R>>> monitor(TimeChain<Double, V> updates) {
        List<TimeChain<Double, Box<R>>> argUpdates = this.argumentMonitor.monitor(updates);
        TimeChain<Double, Box<R>> s = this.argumentMonitor.getResult().getSegments();
        ArrayList<TimeChain<Double, Box<R>>> output = new ArrayList<TimeChain<Double, Box<R>>>();
        for (TimeChain<Double, Box<R>> argU : argUpdates) {
            output.addAll(TemporalOp.slidingWindow(s, argU, this.horizon, this.op));
        }
        output.forEach(this.rho::refine);
        return output;
    }

    @Override
    public TimeSignal<Double, Box<R>> getResult() {
        return this.rho;
    }
}

