/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.online.monitoring.temporal;

import eu.quanticol.moonlight.core.base.Box;
import eu.quanticol.moonlight.core.signal.SignalDomain;
import eu.quanticol.moonlight.core.signal.TimeSignal;
import eu.quanticol.moonlight.online.algorithms.BooleanOp;
import eu.quanticol.moonlight.online.monitoring.OnlineMonitor;
import eu.quanticol.moonlight.online.signal.OnlineSignal;
import eu.quanticol.moonlight.online.signal.TimeChain;
import eu.quanticol.moonlight.online.signal.Update;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class AtomicMonitor<V, R extends Comparable<R>>
implements OnlineMonitor<Double, V, Box<R>> {
    private final Function<V, Box<R>> atomicFunction;
    private final TimeSignal<Double, Box<R>> rho;

    public AtomicMonitor(Function<V, Box<R>> atomicFunction, SignalDomain<R> interpretation) {
        this.atomicFunction = atomicFunction;
        this.rho = new OnlineSignal<R>(interpretation);
    }

    public List<Update<Double, Box<R>>> monitorOld(Update<Double, V> signalUpdate) {
        Update<Double, Box<R>> u = BooleanOp.atom(signalUpdate, this.atomicFunction);
        ArrayList<Update<Double, Box<R>>> updates = new ArrayList<Update<Double, Box<R>>>();
        updates.add(u);
        this.rho.refine(u);
        return updates;
    }

    @Override
    public List<TimeChain<Double, Box<R>>> monitor(Update<Double, V> signalUpdate) {
        ArrayList updates = new ArrayList();
        updates.add(signalUpdate);
        return this.monitor(Update.asTimeChain(updates));
    }

    @Override
    public List<TimeChain<Double, Box<R>>> monitor(TimeChain<Double, V> updates) {
        TimeChain<Double, Box<R>> us = BooleanOp.atomSequence(updates, this.atomicFunction);
        ArrayList<TimeChain<Double, Box<R>>> output = new ArrayList<TimeChain<Double, Box<R>>>();
        output.add(us);
        this.rho.refine(us);
        return output;
    }

    @Override
    public TimeSignal<Double, Box<R>> getResult() {
        return this.rho;
    }
}

