/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.online.monitoring.spatialtemporal;

import eu.quanticol.moonlight.core.base.Box;
import eu.quanticol.moonlight.core.signal.SignalDomain;
import eu.quanticol.moonlight.core.signal.SpaceTimeSignal;
import eu.quanticol.moonlight.online.algorithms.BooleanOp;
import eu.quanticol.moonlight.online.monitoring.OnlineMonitor;
import eu.quanticol.moonlight.online.signal.OnlineSpaceTimeSignal;
import eu.quanticol.moonlight.online.signal.TimeChain;
import eu.quanticol.moonlight.online.signal.Update;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;

public class UnaryMonitor<V, R extends Comparable<R>>
implements OnlineMonitor<Double, List<V>, List<Box<R>>> {
    private final UnaryOperator<List<Box<R>>> op;
    private final SpaceTimeSignal<Double, Box<R>> rho;
    private final OnlineMonitor<Double, List<V>, List<Box<R>>> argumentMonitor;

    public UnaryMonitor(OnlineMonitor<Double, List<V>, List<Box<R>>> argument, UnaryOperator<List<Box<R>>> unaryOp, SignalDomain<R> interpretation, int locations) {
        this.op = unaryOp;
        this.rho = new OnlineSpaceTimeSignal<R>(locations, interpretation);
        this.argumentMonitor = argument;
    }

    @Override
    public List<TimeChain<Double, List<Box<R>>>> monitor(Update<Double, List<V>> signalUpdate) {
        List<TimeChain<Double, List<Box<R>>>> argUpdates = this.argumentMonitor.monitor(signalUpdate);
        ArrayList<TimeChain<Double, List<Box<R>>>> updates = new ArrayList<TimeChain<Double, List<Box<R>>>>();
        for (TimeChain<Double, List<Box<R>>> argU : argUpdates) {
            updates.add(BooleanOp.unarySequence(argU, this.op));
        }
        updates.forEach(this.rho::refine);
        return updates;
    }

    @Override
    public List<TimeChain<Double, List<Box<R>>>> monitor(TimeChain<Double, List<V>> updates) {
        List<TimeChain<Double, List<Box<R>>>> argUpdates = this.argumentMonitor.monitor(updates);
        ArrayList<TimeChain<Double, List<Box<R>>>> output = new ArrayList<TimeChain<Double, List<Box<R>>>>();
        for (TimeChain<Double, List<Box<R>>> argU : argUpdates) {
            output.add(BooleanOp.unarySequence(argU, this.op));
        }
        output.forEach(this.rho::refine);
        return output;
    }

    @Override
    public SpaceTimeSignal<Double, Box<R>> getResult() {
        return this.rho;
    }
}

