/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.offline.monitoring;

import eu.quanticol.moonlight.core.formula.Formula;
import eu.quanticol.moonlight.core.formula.Interval;
import eu.quanticol.moonlight.core.signal.SignalDomain;
import eu.quanticol.moonlight.core.space.DistanceStructure;
import eu.quanticol.moonlight.core.space.SpatialModel;
import eu.quanticol.moonlight.formula.AtomicFormula;
import eu.quanticol.moonlight.formula.Parameters;
import eu.quanticol.moonlight.formula.classic.AndFormula;
import eu.quanticol.moonlight.formula.classic.NegationFormula;
import eu.quanticol.moonlight.formula.classic.OrFormula;
import eu.quanticol.moonlight.formula.spatial.EscapeFormula;
import eu.quanticol.moonlight.formula.spatial.EverywhereFormula;
import eu.quanticol.moonlight.formula.spatial.ReachFormula;
import eu.quanticol.moonlight.formula.spatial.SomewhereFormula;
import eu.quanticol.moonlight.formula.temporal.EventuallyFormula;
import eu.quanticol.moonlight.formula.temporal.GloballyFormula;
import eu.quanticol.moonlight.formula.temporal.HistoricallyFormula;
import eu.quanticol.moonlight.formula.temporal.OnceFormula;
import eu.quanticol.moonlight.formula.temporal.SinceFormula;
import eu.quanticol.moonlight.formula.temporal.UntilFormula;
import eu.quanticol.moonlight.offline.monitoring.spatialtemporal.SpatialTemporalMonitor;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class SpatialTemporalMonitoring<S, T, R> {
    private final Map<String, Function<Parameters, Function<T, R>>> atoms;
    private final Map<String, Function<SpatialModel<S>, DistanceStructure<S, ?>>> distanceFunctions;
    private final SignalDomain<R> module;
    private final boolean parallel;

    public SpatialTemporalMonitoring(Map<String, Function<Parameters, Function<T, R>>> atomicPropositions, Map<String, Function<SpatialModel<S>, DistanceStructure<S, ?>>> distanceFunctions, SignalDomain<R> module, boolean parallelize) {
        this.atoms = atomicPropositions;
        this.module = module;
        this.distanceFunctions = distanceFunctions;
        this.parallel = parallelize;
    }

    public SpatialTemporalMonitoring(Map<String, Function<Parameters, Function<T, R>>> atomicPropositions, Map<String, Function<SpatialModel<S>, DistanceStructure<S, ?>>> distanceFunctions, SignalDomain<R> module) {
        this(atomicPropositions, distanceFunctions, module, false);
    }

    private SpatialTemporalMonitor<S, T, R> generateMonitor(AtomicFormula f) {
        Function<Parameters, Function<Object, R>> atomicFunc = this.atoms.get(f.getAtomicId());
        if (atomicFunc == null) {
            throw new IllegalArgumentException("Unknown atomic ID " + f.getAtomicId());
        }
        Function<T, R> atomic = atomicFunc.apply(null);
        return SpatialTemporalMonitor.atomicMonitor(atomic);
    }

    private SpatialTemporalMonitor<S, T, R> generateMonitor(AndFormula f) {
        SpatialTemporalMonitor<S, T, R> leftMonitor = this.monitor(f.getFirstArgument());
        SpatialTemporalMonitor<S, T, R> rightMonitor = this.monitor(f.getSecondArgument());
        return SpatialTemporalMonitor.andMonitor(leftMonitor, this.module, rightMonitor);
    }

    public <F extends Formula> SpatialTemporalMonitor<S, T, R> monitor(F f) {
        F f2 = f;
        Objects.requireNonNull(f2);
        F f3 = f2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AtomicFormula.class, NegationFormula.class, AndFormula.class, OrFormula.class, EventuallyFormula.class, GloballyFormula.class, UntilFormula.class, OnceFormula.class, HistoricallyFormula.class, SinceFormula.class, SomewhereFormula.class, EverywhereFormula.class, EscapeFormula.class, ReachFormula.class}, f3, n)) {
            case 0 -> {
                AtomicFormula atomic = (AtomicFormula)f3;
                yield this.generateMonitor(atomic);
            }
            case 1 -> {
                NegationFormula negation = (NegationFormula)f3;
                yield this.generateMonitor(negation);
            }
            case 2 -> {
                AndFormula and = (AndFormula)f3;
                yield this.generateMonitor(and);
            }
            case 3 -> {
                OrFormula or = (OrFormula)f3;
                yield this.generateMonitor(or);
            }
            case 4 -> {
                EventuallyFormula ev = (EventuallyFormula)f3;
                yield this.generateMonitor(ev);
            }
            case 5 -> {
                GloballyFormula globally = (GloballyFormula)f3;
                yield this.generateMonitor(globally);
            }
            case 6 -> {
                UntilFormula until = (UntilFormula)f3;
                yield this.generateMonitor(until);
            }
            case 7 -> {
                OnceFormula once = (OnceFormula)f3;
                yield this.generateMonitor(once);
            }
            case 8 -> {
                HistoricallyFormula hs = (HistoricallyFormula)f3;
                yield this.generateMonitor(hs);
            }
            case 9 -> {
                SinceFormula since = (SinceFormula)f3;
                yield this.generateMonitor(since);
            }
            case 10 -> {
                SomewhereFormula some = (SomewhereFormula)f3;
                yield this.generateMonitor(some);
            }
            case 11 -> {
                EverywhereFormula every = (EverywhereFormula)f3;
                yield this.generateMonitor(every);
            }
            case 12 -> {
                EscapeFormula escape = (EscapeFormula)f3;
                yield this.generateMonitor(escape);
            }
            case 13 -> {
                ReachFormula reach = (ReachFormula)f3;
                yield this.generateMonitor(reach);
            }
            default -> this.illegalFormula(f);
        };
    }

    private SpatialTemporalMonitor<S, T, R> illegalFormula(Formula f) {
        throw new IllegalArgumentException("Unsupported formula: " + f);
    }

    private SpatialTemporalMonitor<S, T, R> generateMonitor(OrFormula f) {
        SpatialTemporalMonitor<S, T, R> leftMonitor = this.monitor(f.getFirstArgument());
        SpatialTemporalMonitor<S, T, R> rightMonitor = this.monitor(f.getSecondArgument());
        return SpatialTemporalMonitor.orMonitor(leftMonitor, this.module, rightMonitor);
    }

    private SpatialTemporalMonitor<S, T, R> generateMonitor(NegationFormula f) {
        SpatialTemporalMonitor<S, T, R> argumentMonitoring = this.monitor(f.getArgument());
        return SpatialTemporalMonitor.notMonitor(argumentMonitoring, this.module);
    }

    private SpatialTemporalMonitor<S, T, R> generateMonitor(EventuallyFormula f) {
        SpatialTemporalMonitor<S, T, R> argMonitor = this.monitor(f.getArgument());
        if (f.isUnbounded()) {
            return SpatialTemporalMonitor.eventuallyMonitor(argMonitor, this.module);
        }
        Interval interval = f.getInterval();
        return SpatialTemporalMonitor.eventuallyMonitor(argMonitor, this.module, interval);
    }

    private SpatialTemporalMonitor<S, T, R> generateMonitor(GloballyFormula f) {
        SpatialTemporalMonitor<S, T, R> argMonitor = this.monitor(f.getArgument());
        if (f.isUnbounded()) {
            return SpatialTemporalMonitor.globallyMonitor(argMonitor, this.module);
        }
        Interval interval = f.getInterval();
        return SpatialTemporalMonitor.globallyMonitor(argMonitor, this.module, interval);
    }

    private SpatialTemporalMonitor<S, T, R> generateMonitor(OnceFormula f) {
        SpatialTemporalMonitor<S, T, R> argMonitor = this.monitor(f.getArgument());
        if (f.isUnbounded()) {
            return SpatialTemporalMonitor.onceMonitor(argMonitor, this.module);
        }
        Interval interval = f.getInterval();
        return SpatialTemporalMonitor.onceMonitor(argMonitor, this.module, interval);
    }

    private SpatialTemporalMonitor<S, T, R> generateMonitor(HistoricallyFormula f) {
        SpatialTemporalMonitor<S, T, R> argMonitor = this.monitor(f.getArgument());
        if (f.isUnbounded()) {
            return SpatialTemporalMonitor.historicallyMonitor(argMonitor, this.module);
        }
        Interval interval = f.getInterval();
        return SpatialTemporalMonitor.historicallyMonitor(argMonitor, this.module, interval);
    }

    private SpatialTemporalMonitor<S, T, R> generateMonitor(UntilFormula f) {
        SpatialTemporalMonitor<S, T, R> leftMonitor = this.monitor(f.getFirstArgument());
        SpatialTemporalMonitor<S, T, R> rightMonitor = this.monitor(f.getSecondArgument());
        if (f.isUnbounded()) {
            return SpatialTemporalMonitor.untilMonitor(leftMonitor, rightMonitor, this.module);
        }
        return SpatialTemporalMonitor.untilMonitor(leftMonitor, f.getInterval(), rightMonitor, this.module);
    }

    private SpatialTemporalMonitor<S, T, R> generateMonitor(SinceFormula f) {
        SpatialTemporalMonitor<S, T, R> leftMonitor = this.monitor(f.getFirstArgument());
        SpatialTemporalMonitor<S, T, R> rightMonitor = this.monitor(f.getSecondArgument());
        if (f.isUnbounded()) {
            return SpatialTemporalMonitor.sinceMonitor(leftMonitor, rightMonitor, this.module);
        }
        return SpatialTemporalMonitor.sinceMonitor(leftMonitor, f.getInterval(), rightMonitor, this.module);
    }

    private SpatialTemporalMonitor<S, T, R> generateMonitor(ReachFormula f) {
        SpatialTemporalMonitor<S, T, R> leftMonitor = this.monitor(f.getFirstArgument());
        SpatialTemporalMonitor<S, T, R> rightMonitor = this.monitor(f.getSecondArgument());
        Function<SpatialModel<S>, DistanceStructure<S, ?>> distanceFunction = this.distanceFunctions.get(f.getDistanceFunctionId());
        return SpatialTemporalMonitor.reachMonitor(leftMonitor, distanceFunction, rightMonitor, this.module);
    }

    private SpatialTemporalMonitor<S, T, R> generateMonitor(SomewhereFormula f) {
        SpatialTemporalMonitor<S, T, R> argMonitor = this.monitor(f.getArgument());
        Function<SpatialModel<S>, DistanceStructure<S, ?>> distanceFunction = this.distanceFunctions.get(f.getDistanceFunctionId());
        return SpatialTemporalMonitor.somewhereMonitor(argMonitor, distanceFunction, this.module, this.parallel);
    }

    private SpatialTemporalMonitor<S, T, R> generateMonitor(EverywhereFormula f) {
        SpatialTemporalMonitor<S, T, R> argMonitor = this.monitor(f.getArgument());
        Function<SpatialModel<S>, DistanceStructure<S, ?>> distanceFunction = this.distanceFunctions.get(f.getDistanceFunctionId());
        return SpatialTemporalMonitor.everywhereMonitor(argMonitor, distanceFunction, this.module, this.parallel);
    }

    private SpatialTemporalMonitor<S, T, R> generateMonitor(EscapeFormula f) {
        SpatialTemporalMonitor<S, T, R> argMonitor = this.monitor(f.getArgument());
        Function<SpatialModel<S>, DistanceStructure<S, ?>> distanceFunction = this.distanceFunctions.get(f.getDistanceFunctionId());
        return SpatialTemporalMonitor.escapeMonitor(argMonitor, distanceFunction, this.module);
    }
}

