/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.offline.algorithms;

import eu.quanticol.moonlight.offline.signal.Signal;
import eu.quanticol.moonlight.offline.signal.SignalCursor;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class BooleanOp<T, R> {
    private static final String ERROR = "signal data structure failed irreparably";
    private final boolean forward;
    private Signal<R> output;
    private double time;

    public BooleanOp() {
        this.forward = true;
    }

    public BooleanOp(boolean isForward) {
        this.forward = isForward;
    }

    private static <T> T error() {
        throw new UnsupportedOperationException(ERROR);
    }

    public Signal<R> applyUnary(Signal<T> s, Function<T, R> op) {
        return this.applyOp(cursors -> op.apply(((SignalCursor)cursors.get(0)).getCurrentValue()), s);
    }

    public Signal<R> applyBinary(Signal<T> s1, BiFunction<T, T, R> op, Signal<T> s2) {
        return this.applyOp(cursors -> op.apply(((SignalCursor)cursors.get(0)).getCurrentValue(), ((SignalCursor)cursors.get(1)).getCurrentValue()), s1, s2);
    }

    @SafeVarargs
    private Signal<R> applyOp(Function<List<SignalCursor<Double, T>>, R> op, Signal<T> ... signals) {
        this.output = new Signal();
        this.setStartingTime(signals);
        List cs = this.prepareCursors(signals);
        this.apply(cs, () -> op.apply(cs));
        this.setEndingTime(signals);
        return this.output;
    }

    public <K> Signal<K> filterUnary(Signal<K> s, Predicate<K> p) {
        return this.filterOp(cursors -> ((SignalCursor)cursors.get(0)).getCurrentValue(), p, s);
    }

    @SafeVarargs
    private <K> Signal<K> filterOp(Function<List<SignalCursor<Double, K>>, K> op, Predicate<K> p, Signal<K> ... signals) {
        this.output = new Signal();
        this.setStartingTime(signals);
        List cs = this.prepareCursors(signals);
        this.applyFilter(cs, p, () -> op.apply(cs));
        this.setEndingTime(signals);
        return this.output;
    }

    private <K> void applyFilter(List<SignalCursor<Double, K>> cursors, Predicate<K> p, Supplier<R> value) {
        while (SignalCursor.isNotCompleted(cursors)) {
            this.addResult(p.test(value.get()) ? (R)value.get() : null);
            this.moveCursorsForward(cursors);
        }
    }

    @SafeVarargs
    private <K> void setStartingTime(Signal<K> ... signals) {
        this.time = this.forward ? this.maxStart(Arrays.stream(signals)) : this.minEnd(Arrays.stream(signals));
    }

    private <K> double maxStart(Stream<Signal<K>> stream) {
        return stream.map(Signal::getStart).reduce(Math::max).orElseGet(BooleanOp::error);
    }

    private <K> double minEnd(Stream<Signal<K>> stream) {
        return stream.map(Signal::getEnd).reduce(Math::min).orElseGet(BooleanOp::error);
    }

    @SafeVarargs
    private <K> void setEndingTime(Signal<K> ... signals) {
        if (!this.output.isEmpty()) {
            double end = this.minEnd(Arrays.stream(signals));
            this.output.endAt(end);
        }
    }

    private <K> void apply(List<SignalCursor<Double, K>> cursors, Supplier<R> value) {
        while (SignalCursor.isNotCompleted(cursors)) {
            this.addResult(value.get());
            this.moveCursorsForward(cursors);
        }
    }

    @SafeVarargs
    private <K> List<SignalCursor<Double, K>> prepareCursors(Signal<K> ... signals) {
        return Arrays.stream(signals).map(s -> {
            SignalCursor<Double, Double> c = s.getIterator(this.forward);
            c.move(this.time);
            return c;
        }).toList();
    }

    private void addResult(R value) {
        if (this.forward) {
            this.output.add(this.time, value);
        } else {
            this.output.addBefore(this.time, value);
        }
    }

    private <K> void moveCursorsForward(List<SignalCursor<Double, K>> cursors) {
        this.time = cursors.stream().map(this::moveTime).reduce(this.rightEndingTime()).orElseGet(BooleanOp::error);
        cursors.forEach(c -> c.move(this.time));
    }

    private BinaryOperator<Double> rightEndingTime() {
        if (this.forward) {
            return Math::min;
        }
        return Math::max;
    }

    private <K> double moveTime(SignalCursor<Double, K> cursor) {
        if (this.forward) {
            return cursor.nextTime();
        }
        return cursor.previousTime();
    }
}

