/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.core.space;

import eu.quanticol.moonlight.core.base.Pair;
import eu.quanticol.moonlight.core.space.DistanceStructure;
import eu.quanticol.moonlight.core.space.LocationService;
import eu.quanticol.moonlight.core.space.SpatialModel;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class SpaceIterator<T extends Comparable<T>, S> {
    private final LocationService<T, S> locSvc;
    private final Function<SpatialModel<S>, DistanceStructure<S, ?>> dist;
    private Pair<T, SpatialModel<S>> currSpace;
    private Pair<T, SpatialModel<S>> nextSpace;
    private Iterator<Pair<T, SpatialModel<S>>> spaceItr;

    public SpaceIterator(@NotNull LocationService<T, S> locationService, Function<SpatialModel<S>, DistanceStructure<S, ?>> distance) {
        this.locSvc = locationService;
        this.dist = distance;
    }

    public void init(T startingTime) {
        this.spaceItr = this.getSpaceIterator();
        this.seekSpace(startingTime);
    }

    private void seekSpace(T t) {
        this.currSpace = this.spaceItr.next();
        this.nextSpace = this.moveNext();
        while (this.isNextSpaceBeforeTime(t)) {
            this.shiftSpatialModel();
        }
    }

    public void shiftSpatialModel() {
        this.currSpace = this.nextSpace;
        this.nextSpace = this.moveNext();
    }

    private boolean isNextSpaceBeforeTime(T time) {
        return this.nextSpace != null && (this.isBeforeTime(time) || !this.isModelAtSameTime(this.currSpace, time));
    }

    private boolean isBeforeTime(T time) {
        return this.getNextT().compareTo(time) < 0;
    }

    public T getNextT() {
        return (T)((Comparable)this.nextSpace.getFirst());
    }

    private boolean isModelAtSameTime(Pair<T, SpatialModel<S>> model, T time) {
        return ((Comparable)model.getFirst()).equals(time);
    }

    private Pair<T, SpatialModel<S>> moveNext() {
        return this.spaceItr.hasNext() ? this.spaceItr.next() : null;
    }

    private Iterator<Pair<T, SpatialModel<S>>> getSpaceIterator() {
        return this.locSvc.times();
    }

    public boolean isLocationServiceEmpty() {
        return this.locSvc.isEmpty();
    }

    public void forEach(T tNext, BiConsumer<T, DistanceStructure<S, ?>> procedure) {
        while (this.isNextSpaceModelWithinHorizon(tNext)) {
            this.shiftSpatialModel();
            T t = this.getCurrentT();
            DistanceStructure<S, ?> f = this.generateDistanceStructure();
            procedure.accept(t, f);
        }
    }

    public T getCurrentT() {
        return (T)((Comparable)this.currSpace.getFirst());
    }

    public DistanceStructure<S, ?> generateDistanceStructure() {
        SpatialModel<S> sm = this.currSpace.getSecond();
        return this.dist.apply(sm);
    }

    public boolean isNextSpaceModelWithinHorizon(T tNext) {
        return this.nextSpace != null && this.isBeforeTime(tNext);
    }

    public boolean isNextSpaceModelMeaningful() {
        return this.nextSpace != null && !this.isModelAtSameTime(this.currSpace, this.getNextT());
    }

    public boolean isNextSpaceModelAtSameTime(T time) {
        return this.nextSpace != null && this.isModelAtSameTime(this.nextSpace, time);
    }

    public T fromNextSpaceOrFallback(T fallback) {
        if (this.nextSpace != null) {
            return this.getNextT();
        }
        return fallback;
    }
}

