# python driver for PCF8574

## Overview
Texas Instruments [PCF8574](https://www.ti.com/product/PCF8574) is an 8-bit I/O expander based on I2C/SMBus. This package allows users to use [PCF8574](https://www.ti.com/product/PCF8574) GPIOs like any standard [arduino](https://www.arduino.cc) GPIOs. Provides standard [arduino](https://www.arduino.cc) like functions `pinMode`, `digitalWrite`, `digitalRead` etc.

## Installation
Package: `pip3 install python-PCF8574` 

Dependencies: `pip3 install -r requirements.txt`

## Usage Examples
`examples/basicExample.py` : A basic workflow for reading and writing a GPIO
`examples/multiDeviceExample.py` : multiple PCF8574 devices
`examples/threadSafeExample.py` : Not implemented

## Example Code
For those who just want to get started fast:

`<TODO>`



## Development and Contributibg Instructions 
The current code base is compatible with python3. Pull requests for new features, bug fixes, and suggestions are welcome! Please create an issue for discussion before working on a substantial change.

## License

[MIT](https://github.com/goutamkumar77/python-PCF8574/blob/master/LICENSE)

