from glob import glob
from json import load
import subprocess
import ctypes
import os


def checkExistanceOfGo():
    try:
        subprocess.check_output(["go", "version"])
        return True
    except:
        return False


def compileLibrary():
    try:
        currentDir = os.getcwd()
        os.chdir(os.path.abspath(os.path.join(
            os.path.dirname(__file__), '..')) + "/go")
        subprocess.check_output(
            ["go", "build", "-buildmode=c-shared", "-o", "./compiled/library.so"])
        os.chdir(currentDir)
        return True
    except:
        return False


def loadLibrary():
    currentDir = (os.path.abspath(
        os.path.join(os.path.dirname(__file__), '..')))
    if not os.path.exists(currentDir + "/go/compiled/library.so"):
        print("Library not found, compiling...")
        compileLibrary()
    # get location of current file
    path = os.path.abspath(os.path.join(
        os.path.dirname(__file__), '..')) + "/go/compiled/library.so"
    library = ctypes.cdll.LoadLibrary(path)
    return library
