// Copyright (c) Mito
import React, { useState, useEffect } from 'react';
import { classNames } from '../../../../utils/classNames';
import Col from '../../../spacing/Col';
import Row from '../../../spacing/Row';
import '../../../../../css/taskpanes/ControlPanel/SortCard.css';
export var SortDirection;
(function (SortDirection) {
    SortDirection["ASCENDING"] = "ascending";
    SortDirection["DESCENDING"] = "descending";
    SortDirection["NONE"] = "none";
})(SortDirection || (SortDirection = {}));
/*
    A modal that allows a user to sort a column
*/
const SortCard = (props) => {
    const [stepID, setStepID] = useState('');
    const [sortDirection, setSortDirection] = useState(SortDirection.NONE);
    const updateSortDirection = (newSortDirection) => {
        // If the user toggled the button that was already selected, turn off the sort
        if (newSortDirection == sortDirection) {
            setSortDirection(SortDirection.NONE);
        }
        else {
            setSortDirection(newSortDirection);
        }
    };
    const sendSortUpdateMessage = async () => {
        // Sort the columns if the sortDirection is not None
        if (sortDirection != SortDirection.NONE) {
            const newStepID = await props.mitoAPI.editSort(props.selectedSheetIndex, props.columnID, sortDirection, stepID);
            setStepID(newStepID);
        }
    };
    useEffect(() => {
        void sendSortUpdateMessage();
    }, [sortDirection]);
    // Determine css styling of sort buttons
    const ascendingButtonClass = sortDirection == SortDirection.ASCENDING ? 'sort-button-selected' : '';
    const descendingButtonClass = sortDirection == SortDirection.DESCENDING ? 'sort-button-selected' : '';
    return (React.createElement(Row, { justify: 'space-between', align: 'center' },
        React.createElement(Col, { span: 4 },
            React.createElement("p", { className: 'text-header-3' }, "Sort")),
        React.createElement(Col, { offset: 2, flex: '1' },
            React.createElement(Row, { suppressTopBottomMargin: true },
                React.createElement(Col, { flex: '1' },
                    React.createElement("button", { className: classNames('sort-button', ascendingButtonClass), onClick: () => updateSortDirection(SortDirection.ASCENDING) }, "Ascending")),
                React.createElement(Col, { offset: 1, flex: '1' },
                    React.createElement("button", { className: classNames('sort-button', descendingButtonClass), onClick: () => updateSortDirection(SortDirection.DESCENDING) }, "Descending"))))));
};
export default SortCard;
//# sourceMappingURL=SortCard.js.map