// Copyright (c) Mito
import React from 'react';
// Import css
import "../../../css/FormulaBar.css";
import "../../../css/mito.css";
import { getFullFormula } from './cellEditorUtils';
import { getCellDataFromCellIndexes } from './utils';
import Col from '../spacing/Col';
import Row from '../spacing/Row';
const FormulaBar = (props) => {
    const { columnHeader, columnFormula, cellValue } = getCellDataFromCellIndexes(props.sheetData, props.selection.endingRowIndex, props.selection.endingColumnIndex);
    const originalFormulaBarValue = '' + (columnFormula !== undefined && columnFormula !== '' ? columnFormula : (cellValue !== undefined ? cellValue : ''));
    const cellEditingCellData = props.editorState === undefined ? undefined : getCellDataFromCellIndexes(props.sheetData, props.editorState.rowIndex, props.editorState.columnIndex);
    const formulaBarColumnHeader = props.editorState === undefined ? columnHeader : cellEditingCellData === null || cellEditingCellData === void 0 ? void 0 : cellEditingCellData.columnHeader;
    const formulaBarValue = props.editorState === undefined ? originalFormulaBarValue : getFullFormula(props.editorState.formula, formulaBarColumnHeader || '', props.editorState.pendingSelectedColumns);
    return (React.createElement(Row, { align: 'center', 
        // Add a border to the top and bottom of the formula bar
        style: {
            borderTop: '1px solid var(--mito-border)',
            borderBottom: '1px solid var(--mito-border)',
            background: 'white'
        }, suppressTopBottomMargin: true },
        React.createElement(Col, { offset: .5 },
            React.createElement("p", { className: "formula-bar-column-header text-header-3 text-overflow-hide" }, formulaBarColumnHeader)),
        React.createElement(Col, null,
            React.createElement("div", { className: "formula-bar-vertical-line" })),
        React.createElement(Col, { flex: '1' },
            React.createElement("input", { className: "formula-bar-formula text-header-3 text-overflow-hide element-width-block", value: formulaBarValue, disabled: true }))));
};
export default FormulaBar;
//# sourceMappingURL=FormulaBar.js.map