import pytest

from ctc import rpc


@pytest.mark.asyncio
async def test_eth_call():
    address = '0x6b175474e89094c44da98b954eedeac495271d0f'
    result = await rpc.async_eth_call(
        to_address=address,
        function_name='name',
    )

    target = 'Dai Stablecoin'
    assert result == target


@pytest.mark.asyncio
async def test_eth_estimate_gas():
    result = await rpc.async_eth_estimate_gas(
        to_address='0x6b175474e89094c44da98b954eedeac495271d0f',
        function_name='name',
    )
    assert result > 0


@pytest.mark.asyncio
async def test_eth_get_balance():
    address = '0x6b175474e89094c44da98b954eedeac495271d0f'
    result = await rpc.async_eth_get_balance(
        address=address,
    )
    assert isinstance(result, int)


@pytest.mark.asyncio
async def test_eth_get_storage_at():
    result = await rpc.async_eth_get_storage_at(
        '0x5e227AD1969Ea493B43F840cfF78d08a6fc17796',
        position=0,
    )

    assert result.startswith('0x')


@pytest.mark.asyncio
async def test_get_code():
    address = '0x5e227AD1969Ea493B43F840cfF78d08a6fc17796'
    target = """
        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
    """.strip()
    code = await rpc.async_eth_get_code(address=address)
    assert code == target

