# Dialogflow Fulfillment Python

[![Made in Nigeria](https://img.shields.io/badge/made%20in-nigeria-008751.svg?style=flat-square)](https://github.com/acekyd/made-in-nigeria)
[![PyPI version](https://badge.fury.io/py/pydialogflow-fulfillment.svg)](https://badge.fury.io/py/pydialogflow-fulfillment)
![PyPI - Python Version](https://img.shields.io/pypi/pyversions/pydialogflow-fulfillment.svg)
[![Documentation Status](https://readthedocs.org/projects/dialogflow-fulfillment-python/badge/?version=latest)](https://dialogflow-fulfillment-python.readthedocs.io/en/latest/?badge=latest)
![GitHub issues](https://img.shields.io/github/issues/emmarex/dialogflow-fulfillment-python.svg)
![PyPI - Downloads](https://img.shields.io/pypi/dm/pydialogflow-fulfillment.svg)

The <a href="https://dialogflow.com/docs/fulfillment" target="_blank">Dialogflow Fulfillment Library</a> allows you to connect natural language understanding and processing to your own systems, APIs, and databases. Using Fulfillment, you can surface commands and information from your services to your users through a natural conversational interface.

This Library makes creating fulfillment for Dialogflow v2 agents with <a href="https://www.djangoproject.com" target="_blank">Django</a> or <a href="http://flask.pocoo.org" target="_blank">Flask</a> easy and simple.

## Supported Features

<ol>
    <li>Confirmation</li>
    <li>Simple Response</li>
    <li>System Intent</li>
    <li>Suggestions</li>
    <li>Link out Suggestion</li>
    <li>Google Assistant Signin</li>
    <li>Permissions</li>
    <li>RegisterUpdate</li>
    <li>DateTime</li>
    <li>DeliveryAddress</li>
    <li>OuputContext</li>
</ol>

## Quick Start

1. <a href="https://console.dialogflow.com/api-client/#/login" target="_blank">Login or Create a Dialogflow Account</a>
2. Create a Dialogflow agent or import samples
3. Setup your Django or Flask API</a>
4. Install this library from Pip using `pip install pydialogflow-fulfillment`
5. Go to <b>Fulfillment > Enable Webhook > Enter the url for your API > Enable webhook for all domains</b> 

## Usage
View <a href="https://dialogflow-fulfillment-python.readthedocs.io/en/latest/" target="_blank">usage documentation</a> on Read the Docs.

## License
See LICENSE.md.
